/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.HomeUtils;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ApplicationProps {
    public static void readApplicationProperties(String key) {
        String homeDir = HomeUtils.getHome(key);
        if (homeDir == null) {
            return;
        }
        String userHomeKey = key + ".user.home";
        String systemUserHomeDir = System.getProperty(userHomeKey);
        try {
            Properties props = ApplicationProps.readApplicationPropertiesImpl(homeDir, key);
            if (props != null) {
                String userHome;
                Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> objectObjectEntry;
                    Map.Entry<Object, Object> entry = objectObjectEntry = iterator.next();
                    String entryKey = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (entryKey.equals(userHomeKey)) continue;
                    System.setProperty(entryKey, value);
                }
                if (systemUserHomeDir == null && (userHome = props.getProperty(userHomeKey)) != null) {
                    userHome = StringUtils.replaceSystemPropertyInString(userHome);
                    userHome = IOUtil.fixPath(userHome);
                    userHome = IOUtil.getAbsolutePath(homeDir, userHome);
                    userHome = IOUtil.canonicalize(userHome);
                    System.setProperty(userHomeKey, userHome);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Properties readApplicationPropertiesImpl(String homeDir, String key) throws IOException {
        File file = new File(homeDir, IOUtil.fixPath("bin/" + key + ".properties"));
        if (file.exists()) {
            Properties props = new Properties();
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] split;
                    if (line.startsWith("#") || StringUtils.isEmpty(line) || (split = line.split("=")).length != 2) continue;
                    String propKey = split[0].trim();
                    String propValue = split[1].trim();
                    propValue = StringUtils.replaceSystemPropertyInString(propValue);
                    propValue = StringUtils.replacePropertyInString(propValue, props);
                    props.setProperty(propKey, propValue);
                }
            }
            return props;
        }
        return null;
    }
}

