/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ArrayUtils {
    public static Object addObjectAndArray(Object obj, Object[] array2) {
        Class<?> arrayClass = array2.getClass();
        Class<?> baseComponent = arrayClass.getComponentType();
        int length2 = Array.getLength(array2);
        Object[] newArray = (Object[])Array.newInstance(baseComponent, 1 + length2);
        newArray[0] = obj;
        System.arraycopy(array2, 0, newArray, 1, length2);
        return newArray;
    }

    public static Object addArrayAndObject(Object[] array2, Object obj) {
        Class<?> baseComponent;
        int length2 = 0;
        if (array2 != null) {
            Class<?> arrayClass = array2.getClass();
            baseComponent = arrayClass.getComponentType();
            length2 = Array.getLength(array2);
        } else {
            baseComponent = obj.getClass();
        }
        Object[] newArray = (Object[])Array.newInstance(baseComponent, 1 + length2);
        newArray[length2] = obj;
        System.arraycopy(array2, 0, newArray, 0, length2);
        return newArray;
    }

    public static Object add(Object array1, Object array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        Class<?> arrayClass = array1.getClass();
        Class<?> baseComponent = arrayClass.getComponentType();
        int length1 = Array.getLength(array1);
        int length2 = Array.getLength(array2);
        if (length1 == 0) {
            return array2;
        }
        if (length2 == 0) {
            return array1;
        }
        Object newArray = Array.newInstance(baseComponent, length1 + length2);
        System.arraycopy(array1, 0, newArray, 0, length1);
        System.arraycopy(array2, 0, newArray, length1, length2);
        return newArray;
    }

    public static Object removeFirst(Object[] array, int count) {
        Class<?> arrayClass = array.getClass();
        Class<?> baseComponent = arrayClass.getComponentType();
        int length = Array.getLength(array);
        int newLength = length - count;
        Object newArray = Array.newInstance(baseComponent, newLength);
        System.arraycopy(array, count, newArray, 0, newLength);
        return newArray;
    }

    public static Object removeLast(Object[] array) {
        int length = Array.getLength(array);
        return ArrayUtils.remove(array, length - 1);
    }

    public static Object remove(Object[] array, int at) {
        Class<?> arrayClass = array.getClass();
        Class<?> baseComponent = arrayClass.getComponentType();
        int length = Array.getLength(array);
        int newLength = length - 1;
        Object newArray = Array.newInstance(baseComponent, newLength);
        System.arraycopy(array, 0, newArray, 0, at);
        System.arraycopy(array, at + 1, newArray, at, length - at - 1);
        return newArray;
    }

    public static Object remove(Object[] array, Object value) {
        Object[] objects = array;
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object == null || !object.equals(value)) continue;
            return ArrayUtils.remove(array, i);
        }
        return array;
    }

    public static Set asSet(Object[] objects) {
        return new HashSet<Object>(Arrays.asList(objects));
    }

    public static byte[] add(byte[] bytes1, byte[] bytes2) {
        byte[] output = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, output, 0, bytes1.length);
        System.arraycopy(bytes2, 0, output, bytes1.length, bytes2.length);
        return output;
    }

    public static boolean contains(Object[] arr, Object valueToFind) {
        return ArrayUtils.contains(arr, valueToFind, 0, arr.length - 1);
    }

    public static boolean contains(Object[] arr, Object valueToFind, int startIndex) {
        return ArrayUtils.contains(arr, valueToFind, startIndex, arr.length - 1);
    }

    public static boolean contains(Object[] arr, Object valueToFind, int startIndex, int endIndex) {
        if (arr == null) {
            throw new IllegalArgumentException("Array should not be null");
        }
        if (valueToFind == null) {
            throw new IllegalArgumentException("Search object should not be null");
        }
        if (startIndex >= arr.length) {
            throw new IllegalArgumentException("Array start index exceeds the array size " + arr.length + ">=" + startIndex);
        }
        if (endIndex >= arr.length) {
            throw new IllegalArgumentException("Array end index exceeds the array size " + arr.length + ">=" + startIndex);
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!valueToFind.equals(arr[i])) continue;
            return true;
        }
        return false;
    }
}

