/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.GlobFilenameFilter;
import com.tplus.transform.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CRLFFixer {
    static void fixCRLF(String inFileName, String outFileName, boolean unixStyle) throws IOException {
        SafeFile.doFileCheck(inFileName);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFileName));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFileName));){
            int c;
            int lastChar = 0;
            while ((c = is.read()) != -1) {
                if (c == 13) {
                    CRLFFixer.flushLastChar(os, lastChar, unixStyle);
                    lastChar = c;
                    continue;
                }
                if (c == 10) {
                    if (lastChar != 13) {
                        CRLFFixer.flushLastChar(os, lastChar, unixStyle);
                    }
                    lastChar = 0;
                    CRLFFixer.writeLF(os, unixStyle);
                    continue;
                }
                CRLFFixer.flushLastChar(os, lastChar, unixStyle);
                lastChar = 0;
                os.write(c);
            }
            CRLFFixer.flushLastChar(os, lastChar, unixStyle);
        }
    }

    static void flushLastChar(OutputStream os, int lastChar, boolean unixStyle) throws IOException {
        if (lastChar == 0) {
            return;
        }
        if (lastChar == 13) {
            CRLFFixer.writeLF(os, unixStyle);
        }
    }

    static void writeLF(OutputStream os, boolean unixStyle) throws IOException {
        if (unixStyle) {
            os.write(10);
        } else {
            os.write(13);
            os.write(10);
        }
    }

    public static void cmtmain(String[] args) throws IOException {
        boolean unixStyle = true;
        ArrayList allFiles = new ArrayList();
        for (String arg2 : args) {
            List files = CRLFFixer.getAllFiles(args[0]);
            allFiles.addAll(allFiles);
        }
        for (String arg1 : args) {
            File arg = new File(arg1);
            String tempOutFile = arg.getAbsolutePath() + ".temp";
            CRLFFixer.fixCRLF(arg.getAbsolutePath(), tempOutFile, unixStyle);
            arg.delete();
            new File(tempOutFile).renameTo(arg);
        }
    }

    static List getAllFiles(String name) {
        File file = new File(name).getAbsoluteFile();
        String dir = file.getParent();
        String filter = file.getName();
        GlobFilenameFilter globFilenameFilter = new GlobFilenameFilter(filter);
        List allFiles = IOUtil.getAllFiles(dir, false, globFilenameFilter);
        return allFiles;
    }
}

