/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.Configuration;
import com.tplus.transform.util.IConfiguration;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationManager {
    private IConfiguration iconfig;
    List configs = new ArrayList();
    static ConfigurationManager instance = new ConfigurationManager();

    public void addConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Null configuration");
        }
        if (!this.exists(configuration.getName())) {
            this.configs.add(configuration);
            if (this.iconfig != null) {
                this.load(this.iconfig, configuration);
            }
        }
    }

    private boolean exists(String name) {
        for (Object config : this.configs) {
            Configuration existing = (Configuration)config;
            if (!existing.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void load(IConfiguration iconfig) {
        this.iconfig = iconfig;
        for (Object config : this.configs) {
            Configuration configuration = (Configuration)config;
            this.load(iconfig, configuration);
        }
    }

    public Configuration getConfig(String name) {
        for (Object config : this.configs) {
            Configuration configuration = (Configuration)config;
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    private void load(IConfiguration iconfig, Configuration configuration) {
        configuration.load(iconfig);
    }

    public void save(IConfiguration iconfig) {
        for (Object config : this.configs) {
            Configuration configuration = (Configuration)config;
            configuration.save(iconfig);
        }
    }

    public List getConfigs() {
        return this.configs;
    }

    public static ConfigurationManager create(IConfiguration config) {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        instance.load(config);
        return instance;
    }

    public static ConfigurationManager getInstance() {
        return instance;
    }
}

