/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.IConfiguration;
import com.tplus.transform.util.ISection;
import com.tplus.transform.util.SectionPrefImpl;
import com.tplus.transform.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ConfigurationPreferenceImpl
implements IConfiguration {
    Preferences appNode;

    public ConfigurationPreferenceImpl(String appName) {
        this.appNode = Preferences.userRoot().node(appName);
    }

    public ConfigurationPreferenceImpl(String appName, boolean user) {
        this.appNode = user ? Preferences.userRoot().node(appName) : Preferences.systemRoot().node(appName);
    }

    @Override
    public ISection getDefaultSection() {
        return null;
    }

    @Override
    public ISection getSection(String secName) {
        return new SectionPrefImpl(this.appNode.node(secName));
    }

    @Override
    public ISection findSection(String secName) {
        try {
            if (this.appNode.nodeExists(secName)) {
                return this.getSection(secName);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean removeSection(String secName) {
        try {
            this.appNode.node(secName).removeNode();
            return true;
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean save() {
        try {
            this.appNode.flush();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String fileName) throws IOException, BackingStoreException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileName));){
            this.appNode.exportSubtree(stream);
        }
        finally {
            FileUtil.elevateFileUserPermission(fileName);
        }
    }

    @Override
    public boolean flush() {
        try {
            this.appNode.flush();
            return true;
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return false;
        }
    }
}

