/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.IllegalValueException;
import com.tplus.transform.util.CharConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class EscapedStringLiteral {
    public static String toJavaString(String escapedString) throws IllegalValueException {
        return EscapedStringLiteral.escapedStringToJavaString(escapedString);
    }

    public static String toJavaStringUnChecked(String escapedString) throws IllegalArgumentException {
        try {
            return EscapedStringLiteral.escapedStringToJavaString(escapedString);
        }
        catch (IllegalValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static String escapedStringToJavaString(String escapedString) throws IllegalValueException {
        return CharConverter.UNICODE_ESCAPE.parseLiteral(escapedString);
    }

    public static String toStringLiteral(String escapedString, boolean useUnicodeEscape) throws IllegalArgumentException {
        return EscapedStringLiteral.toStringLiteral(escapedString, useUnicodeEscape ? CharConverter.UNICODE_ESCAPE : CharConverter.NO_UNICODE_ESCAPE);
    }

    public static String toStringLiteral(String escapedString, CharConverter charConverter) throws IllegalArgumentException {
        try {
            return charConverter.parseLiteral(escapedString, true);
        }
        catch (IllegalValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String toString(String escapedString) throws IllegalArgumentException {
        try {
            CharConverter charConverter = CharConverter.UNICODE_ESCAPE;
            return charConverter.parseLiteral(escapedString, false);
        }
        catch (IllegalValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String javaStringtoStringLiteral(String javaString, boolean useUnicodeEscape) throws IllegalArgumentException {
        CharConverter charConverter = EscapedStringLiteral.getCharConverter(useUnicodeEscape);
        return charConverter.toLiteral(javaString);
    }

    public static String convertToLiteral(char val, boolean useUnicodeEscape) {
        CharConverter charConverter = EscapedStringLiteral.getCharConverter(useUnicodeEscape);
        return charConverter.toLiteral(val);
    }

    private static CharConverter getCharConverter(boolean useUnicodeEscape) {
        CharConverter charConverter = useUnicodeEscape ? CharConverter.UNICODE_ESCAPE : CharConverter.NO_UNICODE_ESCAPE;
        return charConverter;
    }

    public static void cmtmain(String[] args) throws Exception {
        char c = ']';
        System.out.println((int)c);
        System.out.println(c);
        System.out.println(EscapedStringLiteral.toStringLiteral("\\#x3A", true));
    }

    private static void testIn() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((line = reader.readLine()) != null) {
            try {
                System.out.println("Literal:" + EscapedStringLiteral.toStringLiteral(line, true));
                System.out.println("Java   :" + EscapedStringLiteral.toJavaString(line));
            }
            catch (IllegalValueException e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

