/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.ArrayUtils;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.Version;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.UIManager;

public class ExecUtil {
    static final String[] windowNTOS = new String[]{"nt", "2000", "xp", "2003", "2005", "2006", "vista"};
    static final String[] window95OS = new String[]{"95", "98", "me"};
    protected static Log log = LogFactory.getLog(ExecUtil.class);
    private static final String WINDOWS = "windows";
    private static final String JAVA_VERSION = "java.version";
    public static final String START = "Start";
    public static final String CMD = "cmd";
    private static final String XDG_OPEN = "xdg-open";
    static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public static boolean isMAC_OSX() {
        return MAC_OS_X;
    }

    public static boolean isWindows(boolean nt) {
        if (nt) {
            return ExecUtil.isWindowsNT();
        }
        return ExecUtil.isWindows();
    }

    public static boolean isWindows() {
        String osName = ExecUtil.getOSName();
        return osName.contains(WINDOWS);
    }

    public static boolean isLinux() {
        String osName = ExecUtil.getOSName();
        return osName.contains("linux");
    }

    public static boolean isWindowsNT() {
        String osName = ExecUtil.getOSName();
        return osName.contains(WINDOWS) && !ExecUtil.matchIn(osName, window95OS);
    }

    static boolean matchIn(String str, String[] string) {
        for (String s : string) {
            if (!str.contains(s)) continue;
            return true;
        }
        return false;
    }

    private static String getOSName() {
        String osName = System.getProperty("os.name");
        osName = osName == null ? "" : osName;
        osName = osName.toLowerCase(Locale.US);
        return osName;
    }

    public static boolean isWindowsXP() {
        String osName = ExecUtil.getOSName();
        return osName.indexOf(WINDOWS) >= 0 && osName.indexOf("xp") >= 0;
    }

    public static boolean isUsingWindowXPVisualStyles() {
        if (!ExecUtil.isWindows()) {
            return false;
        }
        boolean xpthemeActive = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        if (!xpthemeActive) {
            return false;
        }
        try {
            return System.getProperty("swing.noxp") == null;
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    public static boolean isNativeLookAndFeel() {
        return UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static boolean isJRE(String version) {
        String jreVersion = System.getProperty(JAVA_VERSION);
        jreVersion = jreVersion == null ? "" : jreVersion;
        return jreVersion.contains(version);
    }

    public static boolean isJREGreaterThan(Version compareWith) {
        return ExecUtil.getJREVersion().compareTo(compareWith) > 0;
    }

    public static boolean isJREGreaterThanEqual(Version compareWith) {
        return ExecUtil.getJREVersion().compareTo(compareWith) >= 0;
    }

    public static boolean isJREGreaterThanEqual(String compareWith) {
        Version requiredVersion;
        Version jreVersion = ExecUtil.getJREVersion();
        return jreVersion.compareTo(requiredVersion = new Version(compareWith)) >= 0;
    }

    public static boolean isJRELessThan(Version compareWith) {
        return ExecUtil.getJREVersion().compareTo(compareWith) < 0;
    }

    private static Version getJREVersion() {
        String jreVersion = System.getProperty(JAVA_VERSION);
        jreVersion = jreVersion == null ? "" : jreVersion;
        jreVersion = StringUtils.leftStr(jreVersion, "_");
        return new Version(jreVersion);
    }

    public static String getVersion() {
        String jreVersion = System.getProperty(JAVA_VERSION);
        return jreVersion;
    }

    public static String[] splitCommandLine(String cmdLine) {
        ArrayList<String> cmds = new ArrayList<String>();
        StringBuffer lastCommand = new StringBuffer();
        for (int i = 0; i < cmdLine.length(); ++i) {
            char c = cmdLine.charAt(i);
            if (c == '\"') {
                while (i < cmdLine.length() && (c = cmdLine.charAt(i)) != '\"') {
                    lastCommand.append(c);
                    ++i;
                }
                continue;
            }
            if (c == ' ') {
                String cmd = lastCommand.toString().trim();
                if (cmd.length() > 0) {
                    cmds.add(cmd);
                }
                lastCommand.setLength(0);
            }
            lastCommand.append(c);
        }
        String cmd = lastCommand.toString().trim();
        if (cmd.length() > 0) {
            cmds.add(cmd);
        }
        return cmds.toArray(new String[cmds.size()]);
    }

    public static boolean execute(String cmdLine) {
        return ExecUtil.execute(cmdLine, null);
    }

    public static boolean execute(String cmdLine, String workingDir) {
        String[] cmdArray = ExecUtil.splitCommandLine(cmdLine);
        if (ExecUtil.isWindows()) {
            String[] command = new String[]{START};
            if (ExecUtil.isWindows(true)) {
                command = new String[]{CMD, "/C", START};
            }
            command = (String[])ArrayUtils.add(command, cmdArray);
            try {
                Runtime.getRuntime().exec(command, null, new File(workingDir));
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        if (ExecUtil.isLinux()) {
            String[] command = new String[]{XDG_OPEN};
            command = (String[])ArrayUtils.add(command, cmdArray);
            try {
                Runtime.getRuntime().exec(command, null, new File(workingDir));
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean openDocument(String doc) {
        try {
            doc = new File(doc).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ExecUtil.isWindows()) {
            String[] command = new String[]{START, doc};
            if (ExecUtil.isWindowsNT()) {
                command = new String[]{CMD, "/C", doc};
            }
            return ExecUtil.runCommand(command);
        }
        return false;
    }

    public static boolean openURL(String url) {
        if (ExecUtil.isWindows()) {
            String[] command = new String[]{START, url};
            if (ExecUtil.isWindowsNT()) {
                command = new String[]{CMD, "/C", START, url};
            }
            return ExecUtil.runCommand(command);
        }
        if (ExecUtil.isLinux()) {
            String[] command = new String[]{XDG_OPEN, url};
            return ExecUtil.runCommand(command);
        }
        return false;
    }

    public static boolean openFolder(String folder) {
        if (ExecUtil.isWindows()) {
            String[] command = new String[]{START, folder};
            if (ExecUtil.isWindowsNT()) {
                String url = "file:///" + folder;
                url = StringUtils.replace(url, " ", "%20");
                url = StringUtils.replace(url, "&", "%26");
                url = StringUtils.replace(url, "^", "%5E");
                command = new String[]{CMD, "/C", START, url};
            }
            return ExecUtil.runCommand(command);
        }
        return false;
    }

    private static boolean runCommand(String[] command) {
        try {
            Runtime.getRuntime().exec(command);
            return true;
        }
        catch (IOException ex) {
            log.error("Error running command " + ExecUtil.prepareCommandLineDisplayString(command), ex);
            return false;
        }
    }

    public static String prepareCommandLineDisplayString(String[] exec) {
        StringBuffer toRet = new StringBuffer();
        for (String anExec : exec) {
            toRet.append("\"" + anExec + "\" ");
        }
        return toRet.toString();
    }

    public static boolean isMACLookAndFeel() {
        return UIManager.getLookAndFeel().getName().toLowerCase().contains("quaqua");
    }
}

