/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.TreeSet;

public class ExtensionFileNameFilter
implements FileFilter {
    private TreeSet filters = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    private boolean allowDirectory = true;

    public ExtensionFileNameFilter() {
    }

    public ExtensionFileNameFilter(String extension) {
        this(extension, null);
    }

    public ExtensionFileNameFilter(String extension, boolean allowDirectory) {
        this(extension, null);
        this.allowDirectory = allowDirectory;
    }

    public ExtensionFileNameFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description == null) {
            description = extension.toUpperCase() + " File";
        }
        this.setDescription(description);
    }

    public ExtensionFileNameFilter(String[] filters) {
        this(filters, null);
    }

    public ExtensionFileNameFilter(String[] filters, String description) {
        this();
        for (String filter : filters) {
            this.addExtension(filter);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean isAllowDirectory() {
        return this.allowDirectory;
    }

    public void setAllowDirectory(boolean allowDirectory) {
        this.allowDirectory = allowDirectory;
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return this.allowDirectory;
            }
            String extension = ExtensionFileNameFilter.getExtension(f);
            return extension != null && this.filters.contains(extension);
        }
        return false;
    }

    public static String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) >= 0 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        }
        this.filters.add(extension);
        this.fullDescription = null;
    }

    public String getExtension() {
        if (this.filters.size() == 1) {
            return (String)this.filters.iterator().next();
        }
        return null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator extensions = this.filters.iterator();
                if (extensions != null && extensions.hasNext()) {
                    this.fullDescription = this.fullDescription + "*." + extensions.next();
                    while (extensions.hasNext()) {
                        this.fullDescription = this.fullDescription + ", " + extensions.next();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

