/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.RegexFilenameFilter;

public class GlobFilenameFilter
extends RegexFilenameFilter {
    public static final int STAR_CANNOT_MATCH_NULL_MASK = 2;
    public static final int QUESTION_MATCHES_ZERO_OR_ONE_MASK = 4;

    public GlobFilenameFilter(String glob, int options) {
        super(GlobFilenameFilter.globToPerl5(glob.toCharArray(), 0), options);
    }

    public GlobFilenameFilter(String glob) {
        super(GlobFilenameFilter.globToPerl5(glob.toCharArray(), 0));
    }

    private static boolean __isGlobMetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '[' || ch == ']';
    }

    public static String globToPerl5(char[] pattern, int options) {
        boolean starCannotMatchNull = false;
        StringBuffer buffer = new StringBuffer(2 * pattern.length);
        boolean inCharSet = false;
        boolean questionMatchesZero = (options & 4) != 0;
        starCannotMatchNull = (options & 2) != 0;
        block11: for (int ch = 0; ch < pattern.length; ++ch) {
            switch (pattern[ch]) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        continue block11;
                    }
                    if (starCannotMatchNull) {
                        buffer.append(".+");
                        continue block11;
                    }
                    buffer.append(".*");
                    continue block11;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        continue block11;
                    }
                    if (questionMatchesZero) {
                        buffer.append(".?");
                        continue block11;
                    }
                    buffer.append('.');
                    continue block11;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(pattern[ch]);
                    if (ch + 1 >= pattern.length) continue block11;
                    switch (pattern[ch + 1]) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            continue block11;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(pattern[ch]);
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length - 1) {
                        buffer.append('\\');
                        continue block11;
                    }
                    if (GlobFilenameFilter.__isGlobMetaCharacter(pattern[ch + 1])) {
                        buffer.append(pattern[++ch]);
                        continue block11;
                    }
                    buffer.append('\\');
                    continue block11;
                }
                default: {
                    if (!inCharSet && GlobFilenameFilter.__isPerl5MetaCharacter(pattern[ch])) {
                        buffer.append('\\');
                    }
                    buffer.append(pattern[ch]);
                }
            }
        }
        return buffer.toString();
    }

    private static boolean __isPerl5MetaCharacter(char ch) {
        return ch == '*' || ch == '?' || ch == '+' || ch == '[' || ch == ']' || ch == '(' || ch == ')' || ch == '|' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '\\';
    }
}

