/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.IConfiguration;
import com.tplus.transform.util.ISection;
import com.tplus.transform.util.ISectionImpl;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class IConfigurationImpl
implements IConfiguration {
    private static final String DEFAULT_SECTION_NAME = "DEFAULT";
    boolean modified = false;
    private static final String FILE_ENCODING = "utf-8";
    private String fileName;
    private ISectionImpl defaultSection;
    private Map sections = Collections.synchronizedMap(new SequencedHashMap());

    public IConfigurationImpl(String fileName) throws IOException {
        this(fileName, !new File(fileName).exists());
    }

    public IConfigurationImpl(String fileName, boolean newFile) throws IOException {
        if (newFile) {
            this.createNewConfig(fileName);
        } else {
            this.openConfigFile(fileName);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    private void createNewConfig(String fileName) {
        this.fileName = fileName;
        this.removeAllSections();
        this.defaultSection = new ISectionImpl(DEFAULT_SECTION_NAME, this);
        this.modified = false;
    }

    private void openConfigFile(String fileName) throws IOException {
        this.removeAllSections();
        this.fileName = fileName;
        SafeFile.doFileCheck(fileName);
        try (FileInputStream fs = new FileInputStream(fileName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs, FILE_ENCODING));
            this.read(reader);
            this.modified = false;
        }
    }

    @Override
    public ISection getDefaultSection() {
        return this.defaultSection;
    }

    public synchronized void removeAllSections() {
        this.sections.clear();
        this.modified = true;
    }

    public boolean saveAs(String fileName) {
        this.fileName = fileName;
        return this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean save() {
        if (this.fileName != null) {
            try {
                SafeFile.doFileCheck(this.fileName);
                try (FileOutputStream fs = new FileOutputStream(this.fileName);){
                    PrintWriter ps = new PrintWriter(new OutputStreamWriter((OutputStream)fs, FILE_ENCODING));
                    this.defaultSection.write(ps);
                    Iterator iterator = this.sections.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = iterator.next();
                        String secName = (String)entry.getKey();
                        ISectionImpl sec = (ISectionImpl)entry.getValue();
                        ps.println();
                        ps.println("[" + secName + "]");
                        sec.write(ps);
                    }
                    ps.flush();
                }
                finally {
                    FileUtil.elevateFileUserPermission(this.fileName);
                }
                this.modified = false;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private synchronized void read(BufferedReader reader) throws IOException {
        String line;
        ISectionImpl currentSection = this.defaultSection = new ISectionImpl(DEFAULT_SECTION_NAME, this);
        while ((line = reader.readLine()) != null) {
            int position = (line = line.trim()).indexOf("//");
            if (position == 0 || (position = line.indexOf("#")) == 0) continue;
            int startBracPos = line.indexOf(91);
            if (startBracPos == 0) {
                int closeBracPos = line.indexOf(93);
                if (closeBracPos == -1) continue;
                String secName = line.substring(startBracPos + 1, closeBracPos);
                currentSection = this.createSection(secName);
                continue;
            }
            int pos = line.indexOf(61);
            if (pos != -1) {
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                key = key.trim();
                value = value.trim();
                this.addKeyValue(currentSection, key, value);
                continue;
            }
            if (line.equals("")) continue;
            this.addKeyValue(currentSection, line.trim(), "");
        }
    }

    private ISectionImpl createSection(String sectionName) {
        ISectionImpl sec = new ISectionImpl(sectionName, this);
        this.sections.put(sectionName, sec);
        this.modified = true;
        return sec;
    }

    private void addKeyValue(ISectionImpl sec, String key, String val) {
        sec.addKeyValue(key, val);
    }

    public static IConfigurationImpl createNew(String fileName) {
        try {
            return new IConfigurationImpl(fileName, true);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static IConfigurationImpl open(String fileName) {
        try {
            return new IConfigurationImpl(fileName, false);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ISection getSection(String sectionName) {
        ISection sec = this.findSection(sectionName);
        if (sec == null) {
            sec = this.createSection(sectionName);
        }
        return sec;
    }

    @Override
    public ISection findSection(String sectionName) {
        ISectionImpl sec = (ISectionImpl)this.sections.get(sectionName);
        return sec;
    }

    @Override
    public boolean removeSection(String sectionName) {
        Object sec = this.sections.remove(sectionName);
        return sec != null;
    }

    @Override
    public boolean flush() {
        return this.save();
    }
}

