/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.lang.DoubleUtils;
import com.tplus.transform.util.ApplicationUtils;
import com.tplus.transform.util.DeleteOnExitHook;
import com.tplus.transform.util.ExecUtil;
import com.tplus.transform.util.ExtensionFileNameFilter;
import com.tplus.transform.util.NoOpFileFilter;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.io.FileUtil;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IOUtil {
    public static final int OneK = 1024;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Log log = LogFactory.getLog(IOUtil.class);
    static volatile int counter = -1;
    static boolean JRE13 = ExecUtil.isJRE("1.3");
    static boolean JRE16 = ExecUtil.isJRE("1.6");
    public static final long ONE_KB = 1024L;
    public static final int ONE_K = 1024;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void delDir(File dir, String name, boolean recursive) {
        File[] files = dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory() && file.getName().equals(name)) {
                IOUtil.delDir(file);
            }
            if (!file.isDirectory() || !recursive) continue;
            IOUtil.delDir(file, name, recursive);
        }
    }

    public static void delChildren(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file1 : files) {
                IOUtil.delDir(file1);
            }
        }
    }

    public static boolean delDir(File file) {
        File[] files;
        boolean allDeleted = true;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file1 : files) {
                if (IOUtil.delDir(file1)) continue;
                allDeleted = false;
            }
        }
        if (!file.delete()) {
            allDeleted = false;
        }
        return allDeleted;
    }

    public static void deleteOnExit(File subDir) {
        DeleteOnExitHook.add(subDir.getAbsolutePath());
    }

    public static void deleteOnExit(String subDir) {
        DeleteOnExitHook.add(subDir);
    }

    public static boolean copyFile(String src, String dest) {
        try {
            if (src.equals(dest)) {
                return false;
            }
            SafeFile.doFileCheck(src);
            try (FileInputStream inFile = new FileInputStream(src);){
                byte[] buffer = new byte[16384];
                try (FileOutputStream outFile = new FileOutputStream(dest);){
                    int read;
                    while ((read = inFile.read(buffer)) != -1) {
                        outFile.write(buffer, 0, read);
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        File file = new File(dest);
        file.setLastModified(new File(src).lastModified());
        FileUtil.elevateFileUserPermission(file);
        return true;
    }

    public static boolean copyFileToDir(String src, String destDir) {
        return IOUtil.copyFileToDir(src, destDir, null);
    }

    public static boolean copyFileToDir(String src, String destDir, List filesCreated) {
        return IOUtil.copyFileToDir(src, destDir, false, filesCreated);
    }

    public static boolean copyFileToDir(String src, String destDir, List filesCreated, List failedCopy) {
        return IOUtil.copyFileToDir(src, destDir, false, filesCreated, failedCopy);
    }

    public static boolean copyFileToDir(String src, String destDir, boolean createDir) {
        return IOUtil.copyFileToDir(src, destDir, createDir, null);
    }

    public static boolean copyFileToDir(String src, String destDir, boolean createDir, List filesCreated) {
        return IOUtil.copyFileToDir(src, destDir, createDir, filesCreated, new ArrayList());
    }

    public static boolean copyFileToDir(String src, String destDir, boolean createDir, List filesCreated, List failedCopy) {
        File destFile;
        boolean b;
        String name = new File(src).getName();
        if (createDir && !new File(destDir).exists()) {
            FileUtil.mkdirs(new File(destDir));
            if (filesCreated != null) {
                filesCreated.add(destDir);
            }
        }
        if (b = IOUtil.copyFile(src, (destFile = new File(destDir, name)).getPath())) {
            if (filesCreated != null) {
                filesCreated.add(destFile.getPath());
            }
        } else if (failedCopy != null) {
            failedCopy.add(destFile.getPath());
        }
        return b;
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, Long.toString(System.currentTimeMillis()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!FileUtil.mkdir(temp)) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    public static File createTempDir(String prefix) throws IOException {
        String tempDir = ApplicationUtils.getTempDir();
        return IOUtil.createTempDir(prefix, tempDir);
    }

    public static File createTempDir(String prefix, String tempDir) throws IOException {
        File f;
        int i = 0;
        while (!IOUtil.checkAndCreateDir((f = IOUtil.generateFile(prefix, tempDir)).getPath())) {
            if (i > 100) {
                throw new IOException("Unable to create temporary folder under " + tempDir + "\\" + f.getName());
            }
            ++i;
        }
        return f;
    }

    private static File generateFile(String prefix, String dir) {
        if (counter == -1) {
            counter = new SecureRandom().nextInt() & 0xFFFF;
        }
        return new File(dir, prefix + Integer.toString(++counter));
    }

    public static boolean exists(String fileName) {
        try {
            return new SafeFile(fileName).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFile(String fileName) {
        try {
            return new SafeFile(fileName).isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkAndCreateDir(String fileName) throws IOException {
        File dir = new File(fileName);
        if (dir.exists()) {
            return false;
        }
        boolean mkdir = FileUtil.mkdir(dir);
        return mkdir || dir.exists();
    }

    public static File[] getSubDirectories(File file) {
        File[] files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return files;
    }

    public static void copyFiles(File srcDir, File destDir, boolean includeSub) {
        IOUtil.copyFiles(srcDir, destDir, includeSub, null);
    }

    public static void copyFiles(File srcDir, File destDir, boolean includeSub, List filesCreated) {
        FileFilter noOp = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        };
        IOUtil.copyFiles(srcDir, destDir, noOp, includeSub, filesCreated);
    }

    public static void copyFiles(File srcDir, File destDir, boolean includeSub, List filesCreated, List failedCopy) {
        FileFilter noOp = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        };
        IOUtil.copyFiles(srcDir, destDir, noOp, includeSub, filesCreated, failedCopy);
    }

    public static void copyFiles(File srcDir, File destDir, FileFilter filter, boolean includeSub) {
        IOUtil.copyFiles(srcDir, destDir, filter, includeSub, null);
    }

    public static void copyFiles(File srcDir, File destDir, FileFilter filter, boolean includeSub, List filesCreated) {
        IOUtil.copyFiles(srcDir, destDir, filter, includeSub, filesCreated, new ArrayList());
    }

    public static void copyFiles(File srcDir, File destDir, FileFilter filter, boolean includeSub, List filesCreated, List failedCopy) {
        File[] files = srcDir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (!includeSub) continue;
                File subDir = new File(destDir, file.getName());
                if (!subDir.exists()) {
                    FileUtil.mkdir(subDir);
                    if (filesCreated != null) {
                        filesCreated.add(subDir.getAbsolutePath());
                    }
                }
                IOUtil.copyFiles(file, subDir, filter, includeSub, filesCreated, failedCopy);
                continue;
            }
            if (!filter.accept(file)) continue;
            IOUtil.copyFileToDir(file.getPath(), destDir.getPath(), filesCreated, failedCopy);
        }
    }

    public static String readFileAsString(String fileName, String encoding) throws IOException {
        SafeFile.doFileCheck(fileName);
        InputStreamReader in = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(fileName), encoding) : new InputStreamReader(new FileInputStream(fileName));
        return IOUtil.readString(new BufferedReader(in));
    }

    public static String readFileAsString(String fileName) throws IOException {
        return IOUtil.readString(new BufferedReader(new FileReader(fileName)));
    }

    public static String readFileIgnoreException(String fileName) {
        try {
            return IOUtil.readString(new BufferedReader(new FileReader(fileName)));
        }
        catch (IOException io) {
            log.debug("Error while reading file content ", io.getMessage(), io);
            return fileName;
        }
    }

    public static List readLines(String fileName) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static String readStreamAsString(Class cls, String resourceName) throws IOException {
        return IOUtil.readStreamAsString(cls.getClassLoader().getResourceAsStream(resourceName));
    }

    public static String readStreamAsString(InputStream is) throws IOException {
        return IOUtil.readString(new BufferedReader(new InputStreamReader(is)));
    }

    public static String readStreamAsString(InputStream is, String encoding) throws IOException {
        return IOUtil.readString(new BufferedReader(new InputStreamReader(is, encoding)));
    }

    public static String readString(Reader reader) throws IOException {
        try {
            char[] chars = IOUtil.readCharacters(reader);
            String string = new String(chars);
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static char[] readCharacters(Reader is) throws IOException {
        int read;
        int total = 0;
        int alloc = 2048;
        char[] chars = new char[alloc];
        while ((read = is.read(chars, total, alloc - total)) != -1) {
            if (alloc - (total += read) != 0) continue;
            char[] expandedBytes = new char[alloc *= 2];
            System.arraycopy(chars, 0, expandedBytes, 0, total);
            chars = expandedBytes;
        }
        char[] charsRead = new char[total];
        System.arraycopy(chars, 0, charsRead, 0, total);
        return charsRead;
    }

    public static byte[] readFile(String fileName) throws IOException {
        SafeFile.doFileCheck(fileName);
        try (FileInputStream fis = new FileInputStream(fileName);){
            byte[] byArray = IOUtil.readStream(fis);
            return byArray;
        }
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int read;
        int total = 0;
        int alloc = 2048;
        byte[] bytes = new byte[alloc];
        while ((read = is.read(bytes, total, alloc - total)) != -1) {
            if (alloc - (total += read) != 0) continue;
            byte[] expandedBytes = new byte[alloc *= 2];
            System.arraycopy(bytes, 0, expandedBytes, 0, total);
            bytes = expandedBytes;
        }
        byte[] bytesRead = new byte[total];
        System.arraycopy(bytes, 0, bytesRead, 0, total);
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreams(InputStream is, OutputStream os, boolean closeStreams) throws IOException {
        byte[] buffer = new byte[2048];
        try {
            int read;
            while ((read = is.read(buffer)) != -1) {
                if (Thread.interrupted()) {
                    throw new IOException("Interrupted");
                }
                os.write(buffer, 0, read);
            }
        }
        finally {
            if (closeStreams) {
                is.close();
                os.close();
            }
        }
    }

    public static String getUpdatedTitle(String name, String appTitle) {
        File elementFile = new File(name);
        String simpleName = elementFile.getName();
        String path = elementFile.getParent();
        return IOUtil.getUpdatedTitle(simpleName, path, appTitle);
    }

    public static String getUpdatedTitle(String simpleName, String path, String appTitle) {
        String title = simpleName;
        if (path != null) {
            path = IOUtil.getCompressedFileName(path, 70);
            title = title + " [" + path + "]";
        }
        title = title + " - " + appTitle;
        return title;
    }

    public static String getSimpleTitle(String name) {
        File elementFile = new File(name);
        String simpleName = elementFile.getName();
        return simpleName;
    }

    public static String getCompressedFileName(String fullFileName, int maxCharacters) {
        return IOUtil.getCompressedFileName(fullFileName, maxCharacters, "...");
    }

    public static String getCompressedFileName(String fullFileName, int maxCharacters, String replaceWith) {
        try {
            if (fullFileName == null) {
                return fullFileName;
            }
            String separator = System.getProperty("file.separator");
            String canonicalPath = new File(fullFileName).getCanonicalPath();
            return IOUtil.getCompressedName(canonicalPath, separator, maxCharacters, replaceWith);
        }
        catch (IOException e) {
            return fullFileName;
        }
    }

    public static String getCompressedName(String name, String separator, int maxCharacters, String replaceWith) {
        if (name.length() <= maxCharacters) {
            return name;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(name, separator);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        int tokenSize = tokens.size();
        String fileName = (String)tokens.get(tokenSize - 1);
        StringBuffer compressedFileName = new StringBuffer((String)tokens.get(0));
        for (int forwardTokenIndex = 1; forwardTokenIndex < tokenSize - 1; ++forwardTokenIndex) {
            String nextToken = (String)tokens.get(forwardTokenIndex);
            int newLength = compressedFileName.length() + separator.length() + nextToken.length() + separator.length() + fileName.length();
            if (newLength >= maxCharacters) {
                compressedFileName.append(separator).append(replaceWith);
                break;
            }
            compressedFileName.append(separator).append(nextToken);
        }
        if (tokenSize > 1) {
            compressedFileName.append(separator).append(fileName);
        }
        return compressedFileName.toString();
    }

    public static List getAllFiles(String dir, boolean recurse) {
        return IOUtil.getAllFiles(dir, recurse, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static List getAllFiles(String dir, boolean recurse, String extensions) {
        ArrayList allFiles = new ArrayList();
        String[] strings = StringUtils.split(extensions, ",");
        ExtensionFileNameFilter fileNameFilter = new ExtensionFileNameFilter(strings);
        IOUtil.getAllFiles(dir, allFiles, recurse, fileNameFilter, new NoOpFileFilter());
        return allFiles;
    }

    public static List getAllFiles(String dir, boolean recurse, FileFilter filter) {
        ArrayList allFiles = new ArrayList();
        IOUtil.getAllFiles(dir, allFiles, recurse, filter, new NoOpFileFilter());
        return allFiles;
    }

    public static List getAllFiles(String dir, boolean recurse, FileFilter filter, FileFilter dirFilter) {
        ArrayList allFiles = new ArrayList();
        IOUtil.getAllFiles(dir, allFiles, recurse, filter, dirFilter);
        return allFiles;
    }

    static void getAllFiles(String dir, List allFiles, boolean recurse, FileFilter filter, FileFilter dirFilter) {
        File[] files;
        if (new File(dir).isDirectory() && (files = new File(dir).listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!recurse || !dirFilter.accept(file)) continue;
                    IOUtil.getAllFiles(file.getAbsolutePath(), allFiles, recurse, filter, dirFilter);
                    continue;
                }
                if (!filter.accept(file)) continue;
                allFiles.add(file.getAbsolutePath());
            }
        }
    }

    public static String normalizePath(String path) {
        if (StringUtils.isNotEmpty(path)) {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String fixResourcePath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String fixPath(String path) {
        if (path != null) {
            path = path.replace('/', File.separatorChar);
            path = path.replace('\\', File.separatorChar);
        }
        return path;
    }

    public static String getCommonAncestor(String file1, String file2) {
        if (file1 != null && file2 != null) {
            return RelativePath.getCommonAncestor(new File(file1), new File(file2));
        }
        return null;
    }

    public static boolean isAncestorPath(String parent, String child) {
        parent = IOUtil.canonicalize(parent);
        return (child = IOUtil.canonicalize(child)) != null && child.startsWith(parent + File.separatorChar);
    }

    public static String getAbsolutePath(String relativeToDirName, String relativePath, boolean ignoreProperties) {
        if (!(IOUtil.containsProperty(relativePath = IOUtil.fixPath(relativePath)) && !ignoreProperties || new File(relativePath).isAbsolute())) {
            relativeToDirName = IOUtil.fixPath(relativeToDirName);
            String absPath = new File(relativeToDirName, relativePath).getAbsolutePath();
            return absPath;
        }
        return relativePath;
    }

    public static String getAbsolutePath(String relativeToDirName, String relativePath) {
        return IOUtil.getAbsolutePath(relativeToDirName, relativePath, false);
    }

    public static boolean containsProperty(String relativePath) {
        return relativePath != null && relativePath.contains("${");
    }

    public static String getRelativePathLenient(String relativeTo, String path) {
        if (path == null) {
            return path;
        }
        if (!IOUtil.containsProperty(path = IOUtil.fixPath(path))) {
            String toRet = path;
            if (relativeTo != null) {
                relativeTo = IOUtil.fixPath(relativeTo);
                if (new File(path).isAbsolute()) {
                    toRet = IOUtil.getRelativePath(relativeTo, path);
                }
            }
            return toRet;
        }
        return path;
    }

    public static String getRelativePath(String relativeToDirName, String absPath) {
        if (absPath == null) {
            return absPath;
        }
        relativeToDirName = IOUtil.fixPath(relativeToDirName);
        if (!IOUtil.containsProperty(absPath = IOUtil.fixPath(absPath))) {
            return RelativePath.getRelativePath(new File(relativeToDirName), new File(absPath));
        }
        return absPath;
    }

    public static String getRelativePath(String relativeToDirName, String absPath, boolean handleMacros) {
        if (handleMacros) {
            if (absPath == null || absPath.startsWith("${")) {
                return absPath;
            }
            absPath = IOUtil.fixPath(absPath);
            relativeToDirName = IOUtil.fixPath(relativeToDirName);
            if (!new File(absPath).isAbsolute()) {
                try {
                    return RelativePath.getRelativePath(new File(relativeToDirName), new File(relativeToDirName, absPath).getCanonicalFile());
                }
                catch (Exception e) {
                    log.debug("Error reading the specified file", e.getMessage(), e);
                }
            }
            return RelativePath.getRelativePath(new File(relativeToDirName), new File(absPath));
        }
        return IOUtil.getRelativePath(relativeToDirName, absPath);
    }

    public static String getRelativePath(File relativeToDirName, File absPath) {
        return RelativePath.getRelativePath(relativeToDirName, absPath);
    }

    public static URL toURL(File file) throws MalformedURLException {
        if (file.getAbsolutePath().indexOf(32) != -1 && !JRE13 && !JRE16) {
            String path = file.getAbsolutePath();
            path = StringUtils.replace(path, " ", "%20");
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/") && file.isDirectory()) {
                path = path + "/";
            }
            URL toRet = new URL("file", "", path);
            return toRet;
        }
        URL toRet = file.toURL();
        return toRet;
    }

    public static String toFileName(URL url) {
        String fileName = url.getPath();
        try {
            if (fileName.contains("%20")) {
                fileName = StringUtils.replace(fileName, "%20", " ");
            }
            fileName = new File(fileName).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileName;
    }

    public static String getBaseName(String fileName) {
        File file = new File(fileName);
        String name = file.getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public static String getFileName(String fileName) {
        if (fileName != null) {
            File file = new File(fileName);
            return file.getName();
        }
        return fileName;
    }

    public static String getExtension(String fileName) {
        File file = new File(fileName);
        String name = file.getName();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex);
    }

    public static String replaceExtension(String fileName, String outputExtension) {
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex == -1) {
            return fileName + "." + outputExtension;
        }
        return fileName.substring(0, dotIndex + 1) + outputExtension;
    }

    public static void write(File dataFile, byte[] bytes) throws IOException {
        IOUtil.write(dataFile.getAbsolutePath(), bytes);
    }

    public static void write(String dataFile, byte[] bytes) throws IOException {
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(dataFile));
            bos.write(bytes);
        }
        FileUtil.elevateFileUserPermission(dataFile);
    }

    public static void write(String fileName, String data) throws IOException {
        try (BufferedWriter bos = null;){
            bos = new BufferedWriter(new FileWriter(fileName));
            bos.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String fileName, String data, String encoding) throws IOException {
        try (BufferedWriter bos = null;){
            bos = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding));
            bos.write(data);
        }
        FileUtil.elevateFileUserPermission(fileName);
    }

    public static String forceExtension(String pathName, String ext) {
        int i = pathName.lastIndexOf(".");
        if (i == -1) {
            pathName = pathName + "." + ext;
        }
        return pathName;
    }

    public static String canonicalize(String rootFolder) {
        if (rootFolder != null) {
            try {
                rootFolder = IOUtil.fixPath(rootFolder);
                if (!IOUtil.containsProperty(rootFolder)) {
                    return new File(rootFolder).getCanonicalPath();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rootFolder;
    }

    public static File canonicalize(File rootFolder) {
        if (rootFolder != null) {
            try {
                return rootFolder.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rootFolder;
    }

    public static void main2(String[] args) throws IOException {
        System.out.println(IOUtil.getRelativePath("E:\\Volante3.1\\docs\\CPP\\Clients\\MessageFlow\\cartridge", "E:\\Volante3.1\\docs\\CPP\\Clients\\MessageFlow\\cartridge\\src\\OtherVariants\\MainUsingInputDataObjectParameter.cpp"));
        System.out.println(IOUtil.getRelativePath("E:\\Volante3.1\\docs\\CPP\\Clients\\MessageFlow\\cartridge", "E:\\Volante3.1\\docs\\CPP\\Clients\\MessageFlow\\Readme.doc"));
        System.out.println(IOUtil.getRelativePath("E:\\Volante3.1\\docs\\CPP\\Clients\\MessageFlow\\cartridge", "C:\\CormanLisp\\CormanLisp.dsw"));
    }

    public static void testZip(String[] args) throws IOException {
        String fileName = new File("a.zip").getAbsolutePath();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        String carXMLName = "a.xml";
        ZipEntryOutputStream os = new ZipEntryOutputStream(zipOutputStream, carXMLName);
        PrintWriter ps = new PrintWriter(new OutputStreamWriter(os));
        ps.println("hello world");
        ps.println("hello world");
        ps.println("hello world");
        ps.println("hello world");
        ps.println("hello world");
        ps.println("hello world");
        ps.close();
        zipOutputStream.close();
    }

    public static String byteCountToDisplaySize(long byteSize) {
        double size = byteSize;
        String displaySize = byteSize / 0x40000000L > 0L ? IOUtil.stringizeByteCount(size / 1.073741824E9) + " GB" : (byteSize / 0x100000L > 0L ? IOUtil.stringizeByteCount(size / 1048576.0) + " MB" : (byteSize / 1024L > 0L ? IOUtil.stringizeByteCount(size / 1024.0) + " KB" : IOUtil.stringizeByteCount(size) + " bytes"));
        return displaySize;
    }

    private static String stringizeByteCount(double sizeD) {
        sizeD = (double)Math.round(sizeD * 100.0) / 100.0;
        return DoubleUtils.toString(sizeD, 10, '.', false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractFile(String zipFileName, String entryName, String destFileName) {
        if (!new File(zipFileName).exists()) return false;
        try (ZipFile zin = new ZipFile(zipFileName);){
            ZipEntry zipEntry = null;
            zipEntry = zin.getEntry(entryName);
            if (zipEntry != null) {
                InputStream inputStream = zin.getInputStream(zipEntry);
                IOUtil.copyToFile(inputStream, destFileName);
                boolean bl = true;
                return bl;
            }
            zin.close();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static List extractJar(InputStream inputStream, String destinationFolder) throws IOException {
        ArrayList<String> extractedFiles = new ArrayList<String>();
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(inputStream));){
            ZipEntry zipEntry = null;
            while ((zipEntry = zin.getNextEntry()) != null) {
                String entryName;
                if (zipEntry.isDirectory()) {
                    entryName = zipEntry.getName();
                    entryName = IOUtil.toSystemSeparator(entryName);
                    File file = new File(destinationFolder, entryName);
                    FileUtil.mkdirs(file);
                    continue;
                }
                entryName = zipEntry.getName();
                entryName = IOUtil.toSystemSeparator(entryName);
                String fileName = IOUtil.copyToFile(zin, destinationFolder, entryName);
                long time = zipEntry.getTime();
                if (time > 0L) {
                    new File(fileName).setLastModified(time);
                }
                extractedFiles.add(fileName);
            }
        }
        return extractedFiles;
    }

    public static void exportAsJAR(String jarPath, File[] files, Map<Attributes.Name, String> manifestEntries) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        for (Map.Entry<Attributes.Name, String> entry : manifestEntries.entrySet()) {
            manifest.getMainAttributes().put(entry.getKey(), entry.getValue());
        }
        try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(jarPath), manifest);){
            for (File file : files) {
                IOUtil.createJarEntry(file, "", jarOutputStream);
            }
        }
    }

    private static void createJarEntry(File jarEntry, String prefix, JarOutputStream jarOutputStream) throws IOException {
        if (jarEntry.isDirectory()) {
            prefix = prefix + jarEntry.getName() + "/";
            ZipEntry entry = new ZipEntry(prefix);
            jarOutputStream.putNextEntry(entry);
            jarOutputStream.closeEntry();
            File[] files = jarEntry.listFiles();
            if (files != null) {
                for (File file : files) {
                    IOUtil.createJarEntry(file, prefix, jarOutputStream);
                }
            }
        } else if (jarEntry.isFile()) {
            ZipEntry entry = new ZipEntry(prefix + jarEntry.getName());
            jarOutputStream.putNextEntry(entry);
            FileInputStream in = new FileInputStream(jarEntry);
            IOUtil.copyStreams(in, jarOutputStream, false);
            in.close();
            jarOutputStream.closeEntry();
        }
    }

    private static String toSystemSeparator(String entryName) {
        if (entryName != null) {
            entryName = entryName.replace('\\', File.separatorChar);
            entryName = entryName.replace('/', File.separatorChar);
        }
        return entryName;
    }

    public static String copyToFile(InputStream is, String rootFolder, String relativeFileName) throws IOException {
        File file = new File(rootFolder, relativeFileName);
        file = IOUtil.canonicalize(file);
        FileUtil.mkdirs(file.getParentFile());
        String path = file.getAbsolutePath();
        IOUtil.copyToFile(is, path);
        return path;
    }

    private static void copyToFile(InputStream is, String path) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(path);){
            IOUtil.copyStreams(is, fileOutputStream, false);
        }
        FileUtil.elevateFileUserPermission(path);
    }

    public static String toForwardSlash(String name) {
        return name.replace("\\", "/");
    }

    public static String replace(String name, String text, String with) {
        System.out.println("Replace " + name);
        System.out.println("text " + text);
        System.out.println("with " + with);
        return name.replace(text, with);
    }

    public static void cmtmain(String[] args) {
        System.out.println(IOUtil.getCommonAncestor("D:\\Projects\\SAP\\Integration\\IDOCToISO20022Project", "D:\\Projects\\SAP\\Integration\\IDOCToISO20022"));
        System.out.println(IOUtil.getCommonAncestor("D:\\Projects\\SAP\\Integration\\IDOCToISO20022project", "D:\\Projects\\SAP\\Integration\\IDOCToISO20022ProJect"));
        System.out.println(IOUtil.getCommonAncestor("D:\\Projects\\SAP\\", "D:\\Projects\\SAP\\Integration\\IDOCToISO20022ProJect"));
        System.out.println(IOUtil.getCommonAncestor("D:", "D:\\Projects\\SAP\\"));
        System.out.println(IOUtil.getCommonAncestor("D:", "c:"));
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, output);
        return output.toByteArray();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOUtil.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static class RelativePath {
        private static List getPathList(File f) {
            ArrayList l = new ArrayList();
            try {
                File r = f.getCanonicalFile();
                RelativePath.getPathList(r, l);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return l;
        }

        private static void getPathList(File r, List l) {
            while (r != null) {
                String name = r.getName();
                if (name.length() == 0) {
                    name = r.getAbsolutePath();
                }
                l.add(name);
                r = r.getParentFile();
            }
        }

        private static String matchPathLists(List r, List f) {
            int j;
            String s = "";
            int i = r.size() - 1;
            for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
            }
            while (i >= 0) {
                s = s + ".." + File.separator;
                --i;
            }
            while (j >= 1) {
                s = s + f.get(j) + File.separator;
                --j;
            }
            if (j >= 0) {
                s = s + f.get(j);
            } else if (s.length() == 0) {
                s = ".";
            }
            return s;
        }

        public static String getRelativePath(File home, File f) {
            List homelist = RelativePath.getPathList(home);
            List filelist = RelativePath.getPathList(f);
            if (ExecUtil.isWindows() && !homelist.get(homelist.size() - 1).equals(filelist.get(filelist.size() - 1))) {
                return f.getAbsolutePath();
            }
            String s = RelativePath.matchPathLists(homelist, filelist);
            return s;
        }

        public static String getCommonAncestor(File file1, File file2) {
            List file1List = RelativePath.getPathList(file1);
            List file2List = RelativePath.getPathList(file2);
            Collections.reverse(file1List);
            Collections.reverse(file2List);
            if (ExecUtil.isWindows() && !file1List.get(0).equals(file2List.get(0))) {
                return null;
            }
            int i = 0;
            for (i = 0; i < file2List.size() && i < file1List.size(); ++i) {
                String f2 = (String)file1List.get(i);
                String f1 = (String)file2List.get(i);
                if (!f1.equals(f2)) break;
            }
            File common = file1;
            for (int j = file1List.size() - 1; j >= i; --j) {
                common = common.getParentFile();
            }
            return common.getAbsolutePath();
        }

        public static void main2(String[] args) {
            List files = IOUtil.getAllFiles("C:\\Documents and Settings\\Krish.KRISHNAN\\volante\\config\\swift\\format", true, new ExtensionFileNameFilter(".xml", false));
            System.out.println(files);
        }
    }

    public static class ZipEntryOutputStream
    extends OutputStream {
        private ZipOutputStream zos;

        public ZipEntryOutputStream(ZipOutputStream zos, String name) throws IOException {
            this(zos, name, 8);
        }

        ZipEntryOutputStream(ZipOutputStream zos, String name, int method) throws IOException {
            this.zos = zos;
            ZipEntry e = new ZipEntry(name);
            e.setTime(System.currentTimeMillis());
            e.setMethod(method);
            zos.putNextEntry(e);
        }

        @Override
        public void close() throws IOException {
            this.zos.closeEntry();
        }

        @Override
        public void flush() throws IOException {
            this.zos.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.zos.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.zos.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.zos.write(b, off, len);
        }
    }
}

