/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.Os;
import java.io.File;
import java.util.Vector;

public final class JavaEnvUtils {
    private static final boolean isDos = Os.isFamily("dos");
    private static final boolean isNetware = Os.isName("netware");
    private static final boolean isAix = Os.isName("aix");
    private static final String javaHome = System.getProperty("java.home");
    private static String javaVersion;
    private static int javaVersionNumber;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String JAVA_1_5 = "1.5";
    private static boolean kaffeDetected;
    private static Vector jrePackages;

    private JavaEnvUtils() {
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJavaVersion(String version) {
        return javaVersion.equals(version);
    }

    public static boolean isKaffe() {
        return kaffeDetected;
    }

    public static String getJreExecutable(String command) {
        if (isNetware) {
            return command;
        }
        File jExecutable = null;
        if (isAix) {
            jExecutable = JavaEnvUtils.findInDir(javaHome + "/sh", command);
        }
        if (jExecutable == null) {
            jExecutable = JavaEnvUtils.findInDir(javaHome + "/bin", command);
        }
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        return JavaEnvUtils.addExtension(command);
    }

    public static String getJdkExecutable(String command) {
        if (isNetware) {
            return command;
        }
        File jExecutable = null;
        if (isAix) {
            jExecutable = JavaEnvUtils.findInDir(javaHome + "/../sh", command);
        }
        if (jExecutable == null) {
            jExecutable = JavaEnvUtils.findInDir(javaHome + "/../bin", command);
        }
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        return JavaEnvUtils.getJreExecutable(command);
    }

    private static String addExtension(String command) {
        return command + (isDos ? ".exe" : "");
    }

    private static File findInDir(String dirName, String commandName) {
        File dir = new File(IOUtil.canonicalize(dirName));
        File executable = null;
        if (dir.exists() && !(executable = new File(dir, JavaEnvUtils.addExtension(commandName))).exists()) {
            executable = null;
        }
        return executable;
    }

    private static void buildJrePackages() {
        jrePackages = new Vector();
        switch (javaVersionNumber) {
            case 14: 
            case 15: {
                jrePackages.addElement("org.apache.crimson");
                jrePackages.addElement("org.apache.xalan");
                jrePackages.addElement("org.apache.xml");
                jrePackages.addElement("org.apache.xpath");
                jrePackages.addElement("org.ietf.jgss");
                jrePackages.addElement("org.w3c.dom");
                jrePackages.addElement("org.xml.sax");
            }
            case 13: {
                jrePackages.addElement("org.omg");
                jrePackages.addElement("com.sun.corba");
                jrePackages.addElement("com.sun.jndi");
                jrePackages.addElement("com.sun.media");
                jrePackages.addElement("com.sun.naming");
                jrePackages.addElement("com.sun.org.omg");
                jrePackages.addElement("com.sun.rmi");
                jrePackages.addElement("sunw.io");
                jrePackages.addElement("sunw.util");
            }
            case 12: {
                jrePackages.addElement("com.sun.java");
                jrePackages.addElement("com.sun.image");
            }
        }
        jrePackages.addElement("sun");
        jrePackages.addElement("java");
        jrePackages.addElement("javax");
    }

    public static Vector getJrePackageTestCases() {
        Vector<String> tests = new Vector<String>();
        tests.addElement("java.lang.Object");
        switch (javaVersionNumber) {
            case 14: 
            case 15: {
                tests.addElement("sun.audio.AudioPlayer");
                tests.addElement("org.apache.crimson.parser.ContentModel");
                tests.addElement("org.apache.xalan.processor.ProcessorImport");
                tests.addElement("org.apache.xml.utils.URI");
                tests.addElement("org.apache.xpath.XPathFactory");
                tests.addElement("org.ietf.jgss.Oid");
                tests.addElement("org.w3c.dom.Attr");
                tests.addElement("org.xml.sax.XMLReader");
            }
            case 13: {
                tests.addElement("org.omg.CORBA.Any");
                tests.addElement("com.sun.corba.se.internal.corba.AnyImpl");
                tests.addElement("com.sun.jndi.ldap.LdapURL");
                tests.addElement("com.sun.media.sound.Printer");
                tests.addElement("com.sun.naming.internal.VersionHelper");
                tests.addElement("com.sun.org.omg.CORBA.Initializer");
                tests.addElement("sunw.io.Serializable");
                tests.addElement("sunw.util.EventListener");
            }
            case 12: {
                tests.addElement("javax.accessibility.Accessible");
                tests.addElement("sun.misc.BASE64Encoder");
                tests.addElement("com.sun.image.codec.jpeg.JPEGCodec");
            }
        }
        tests.addElement("sun.reflect.SerializationConstructorAccessorImpl");
        tests.addElement("sun.net.www.http.HttpClient");
        tests.addElement("sun.audio.AudioPlayer");
        return tests;
    }

    public static Vector getJrePackages() {
        if (jrePackages == null) {
            JavaEnvUtils.buildJrePackages();
        }
        return jrePackages;
    }

    static {
        try {
            javaVersion = JAVA_1_0;
            javaVersionNumber = 10;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            ++javaVersionNumber;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            ++javaVersionNumber;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            ++javaVersionNumber;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
            ++javaVersionNumber;
            Class.forName("java.lang.Readable");
            javaVersion = JAVA_1_5;
            ++javaVersionNumber;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        kaffeDetected = false;
        try {
            Class.forName("kaffe.util.NotImplemented");
            kaffeDetected = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

