/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Launcher {
    protected static Log log = LogFactory.getLog("com.volante.designer.simulator");
    public static final String LAUNCH_TAG = "launch";
    public static final String APPLICATION_ATTRIB = "application";
    public static final String WAIT_ATTRIB = "wait";
    public static final String SHUTDOWN_ATTRIB = "shutdown";
    public static final String ARG_TAG = "arg";
    public static final String VALUE_ATTRIB = "value";
    public static final String NAME_ATTRIB = "name";
    String name;
    boolean wait;
    boolean shutdown;
    List arguments = new ArrayList();
    PrintStream out = System.out;
    PrintStream err = System.err;

    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    public void setErrorStream(PrintStream err) {
        this.err = err;
    }

    public String getCommandLine() {
        StringBuffer commandLine = new StringBuffer();
        for (Object argument : this.arguments) {
            commandLine.append(argument);
            commandLine.append(" ");
        }
        return commandLine.toString();
    }

    public void launch() throws Exception {
        try {
            String[] commandLine = this.arguments.toArray(new String[this.arguments.size()]);
            final Process p = Runtime.getRuntime().exec(commandLine);
            Launcher.redirectStream(p.getInputStream(), this.out);
            Launcher.redirectStream(p.getErrorStream(), this.err);
            if (this.shutdown) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            int n = p.exitValue();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            // empty catch block
                        }
                        p.destroy();
                    }
                });
            }
            if (this.wait) {
                p.waitFor();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Thread.yield();
    }

    public static void redirectStream(final InputStream is, final OutputStream os) {
        Thread th = new Thread(){

            @Override
            public void run() {
                byte[] bytes = new byte[1024];
                try {
                    int read;
                    while ((read = is.read(bytes)) != -1) {
                        os.write(bytes, 0, read);
                    }
                }
                catch (IOException e) {
                }
            }
        };
        th.start();
    }

    public void read(Element nd) throws Exception {
        if (!nd.getTagName().equals(LAUNCH_TAG)) {
            throw new Exception("The root tag name should be 'launch'");
        }
        this.name = nd.getAttribute(NAME_ATTRIB);
        String appName = nd.getAttribute(APPLICATION_ATTRIB);
        this.arguments.add(StringUtils.replaceSystemPropertyInString(appName));
        String waitStr = nd.getAttribute(WAIT_ATTRIB);
        this.wait = Boolean.valueOf(waitStr);
        String shutdownStr = nd.getAttribute(SHUTDOWN_ATTRIB);
        this.shutdown = Boolean.valueOf(shutdownStr);
        NodeList argList = nd.getElementsByTagName(ARG_TAG);
        for (int i = 0; i < argList.getLength(); ++i) {
            Element argElm = (Element)argList.item(i);
            String valueStr = argElm.getAttribute(VALUE_ATTRIB);
            this.arguments.add(StringUtils.replaceSystemPropertyInString(valueStr));
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = appName;
        }
    }

    public String getName() {
        return this.name;
    }
}

