/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.Cloneable2;
import com.tplus.transform.util.BinaryPredicate;
import com.tplus.transform.util.EqualsBinaryPredicate;
import com.tplus.transform.util.Function;
import com.tplus.transform.util.LessPredicate;
import com.tplus.transform.util.Predicate;
import com.tplus.transform.util.PropertyFunction;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.ValueEqualsPredicate;
import com.tplus.transform.util.csv.CSVException;
import com.tplus.transform.util.csv.CSVParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class ListUtil {
    public static List splitSupportQuotes(String options, String separator) {
        try {
            return CSVParser.tokenizeLine(options, separator);
        }
        catch (CSVException e) {
            e.printStackTrace();
            return Arrays.asList(StringUtils.split(options, separator));
        }
    }

    public static String toCSV(List list, boolean nullIfEmpty) {
        if (list.size() == 0 && nullIfEmpty) {
            return null;
        }
        return ListUtil.toCSV(list);
    }

    public static String toLSV(List list) {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String item;
            if (i > 0) {
                toRet.append("\n");
            }
            if ((item = (String)list.get(i)).length() == 0) {
                toRet.append(" ");
                continue;
            }
            toRet.append(list.get(i));
        }
        return toRet.toString();
    }

    public static String toDelimited(List list, String delimiter) {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Object o;
            if (i > 0) {
                toRet.append(delimiter);
                if (!Character.isWhitespace(delimiter.charAt(0))) {
                    toRet.append(" ");
                }
            }
            if ((o = list.get(i)) == null) {
                toRet.append(" ");
                continue;
            }
            String item = o.toString();
            if (item.length() == 0) {
                toRet.append(" ");
                continue;
            }
            if (item.contains(delimiter)) {
                item = "\"" + item + "\"";
            }
            toRet.append(item);
        }
        return toRet.toString();
    }

    public static String toCSV(List list) {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Object o;
            if (i > 0) {
                toRet.append(", ");
            }
            if ((o = list.get(i)) == null) {
                toRet.append(" ");
                continue;
            }
            String item = o.toString();
            if (item.length() == 0) {
                toRet.append(" ");
                continue;
            }
            toRet.append(o);
        }
        return toRet.toString();
    }

    public static List fromCSV(String options) {
        ArrayList<String> optionList = new ArrayList<String>();
        if (options != null) {
            boolean toAddEmpty = true;
            StringTokenizer stk = new StringTokenizer(options, ",", true);
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                if (token.equals(",")) {
                    if (toAddEmpty) {
                        optionList.add("");
                    }
                    toAddEmpty = true;
                    continue;
                }
                toAddEmpty = false;
                optionList.add(token.trim());
            }
            if (toAddEmpty) {
                optionList.add("");
            }
        }
        return optionList;
    }

    public static boolean swapItems(List list, int index, int newIndex) {
        if (newIndex < 0) {
            return false;
        }
        if (newIndex >= list.size()) {
            return false;
        }
        Object obj = list.get(newIndex);
        list.set(newIndex, list.get(index));
        list.set(index, obj);
        return true;
    }

    public static void remove(List list, int[] indices) {
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            list.remove(indices[i]);
        }
    }

    public static int countIf(Collection list, Predicate predicate) {
        int count = 0;
        for (Object obj : list) {
            if (!predicate.evaluate(obj)) continue;
            ++count;
        }
        return count;
    }

    public static void replace(List list, Function replacementFunction) {
        ListIterator<Object> iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            iterator.set(replacementFunction.apply(obj));
        }
    }

    public static void replaceIf(List list, Predicate predicate, Function replacementFunction) {
        ListIterator<Object> iterator = list.listIterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!predicate.evaluate(obj)) continue;
            iterator.set(replacementFunction.apply(obj));
        }
    }

    public static Collection removeIf(Collection list, Predicate predicate) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!predicate.evaluate(obj)) continue;
            iterator.remove();
        }
        return list;
    }

    public static Object find(Collection list, Object value) {
        return ListUtil.findIf(list, new ValueEqualsPredicate(value));
    }

    public static Object findIf(Collection list, Predicate predicate) {
        for (Object obj : list) {
            if (!predicate.evaluate(obj)) continue;
            return obj;
        }
        return null;
    }

    public static List subList(Collection src, Predicate predicate) {
        ArrayList toRet = new ArrayList();
        ListUtil.collectIf(src, toRet, predicate);
        return toRet;
    }

    public static Collection collectIf(Collection src, Collection dest, Predicate predicate) {
        for (Object obj : src) {
            if (!predicate.evaluate(obj)) continue;
            dest.add(obj);
        }
        return dest;
    }

    public static List getPropertyList(Collection list, String propertyName) {
        ArrayList toRet = new ArrayList(list.size());
        ListUtil.transform(list, toRet, new PropertyFunction(propertyName));
        return toRet;
    }

    public static Collection transform(Collection list, Collection dest, Function function) {
        for (Object obj : list) {
            dest.add(function.apply(obj));
        }
        return dest;
    }

    public static Collection transformIf(Collection list, Collection dest, Predicate predicate, Function function) {
        for (Object obj : list) {
            if (!predicate.evaluate(obj)) continue;
            dest.add(function.apply(obj));
        }
        return dest;
    }

    public static List unique(List list) {
        ListUtil.unique(list, EqualsBinaryPredicate.INSTANCE);
        return list;
    }

    public static List unique(List list, BinaryPredicate predicate) {
        ListIterator iterator = list.listIterator();
        block0: while (iterator.hasNext()) {
            Object obj = iterator.next();
            ListIterator iterator2 = list.listIterator(iterator.nextIndex());
            while (iterator2.hasNext()) {
                Object obj2 = iterator2.next();
                if (!predicate.match(obj, obj2)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return list;
    }

    public static boolean canMoveUp(int[] rows, int maxRow) {
        return ListUtil.canMoveRows(rows, true, maxRow);
    }

    public static boolean canMoveDown(int[] rows, int maxRow) {
        return ListUtil.canMoveRows(rows, false, maxRow);
    }

    public static boolean canMoveRows(int[] rows, boolean up, int maxRow) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        for (int row : rows) {
            if (up && row == 0) {
                return false;
            }
            if (up || row != maxRow - 1) continue;
            return false;
        }
        return rows.length > 0;
    }

    public static boolean moveRowsUp(List list, int[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            if (!ListUtil.swapItems(list, rows[i], rows[i] - 1)) continue;
            int n = i;
            rows[n] = rows[n] - 1;
        }
        return rows.length > 0;
    }

    public static boolean moveRowsDown(List list, int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            if (!ListUtil.swapItems(list, rows[i], rows[i] + 1)) continue;
            int n = i;
            rows[n] = rows[n] + 1;
        }
        return rows.length > 0;
    }

    public static void removeDuplicates(List messages) {
        for (int i = 0; i < messages.size(); ++i) {
            Object o = messages.get(i);
            if (messages.indexOf(o) >= i) continue;
            messages.remove(i);
            --i;
        }
    }

    public static void cmtmain(String[] args) {
        ListUtil.printList(ListUtil.fromCSV(",F,P"));
        ListUtil.printList(ListUtil.fromCSV("F,P"));
        ListUtil.printList(ListUtil.fromCSV("A,B,"));
        ListUtil.printList(ListUtil.fromCSV("D,,C"));
        ListUtil.printList(ListUtil.fromCSV(""));
        ListUtil.printList(ListUtil.fromCSV(",F"));
        ListUtil.printList(ListUtil.fromCSV(null));
        System.out.println(ListUtil.createList());
        System.out.println(ListUtil.unique(ListUtil.createList()));
        System.out.println(ListUtil.findIf(ListUtil.createList(), new ValueEqualsPredicate("dog")));
        ArrayList outList = new ArrayList();
        ListUtil.collectIf(ListUtil.createList(), outList, new LessPredicate("pig"));
        System.out.println(outList);
        ArrayList outList2 = new ArrayList();
        ListUtil.transform(ListUtil.createList(), outList2, new Function(){

            @Override
            public Object apply(Object obj) {
                return ((String)obj).toUpperCase();
            }
        });
        System.out.println(outList2);
        System.out.println(ListUtil.removeIf(ListUtil.createList(), new ValueEqualsPredicate("pig")));
    }

    private static List createList() {
        return new ArrayList<String>(Arrays.asList("cat", "dog", "donkey", "cat", "pig"));
    }

    public static String listToString(List list) {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Object s = list.get(i);
            toRet.append(i + 1).append(") ").append(s).append("\n");
        }
        return toRet.toString();
    }

    public static void printList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object s = list.get(i);
            System.out.println("[" + (i + 1) + "]" + s);
        }
        System.out.println("**************");
    }

    public static List deepClone(List joins) {
        ArrayList<Object> toRet = new ArrayList<Object>();
        for (Object obj : joins) {
            if (obj instanceof Cloneable2) {
                toRet.add(((Cloneable2)obj).clone());
                continue;
            }
            throw new IllegalArgumentException(obj.getClass() + " not of type Cloneble2");
        }
        return toRet;
    }

    public static int findIndex(List list, Object object) {
        if (object != null && list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != object) continue;
                return i;
            }
        }
        return -1;
    }

    public static Set findDuplicates(List listContainingDuplicates) {
        return ListUtil.findDuplicates(listContainingDuplicates, null, null);
    }

    public static Set findDuplicates(List listContainingDuplicates, Comparator comparator) {
        return ListUtil.findDuplicates(listContainingDuplicates, comparator, null);
    }

    public static Set findDuplicates(List listContainingDuplicates, Comparator comparator, ToDoAction onDuplicate) {
        HashSet toReturn = new HashSet();
        TreeSet uniqueSet = new TreeSet(comparator);
        for (Object data : listContainingDuplicates) {
            if (uniqueSet.add(data) || onDuplicate != null && !onDuplicate.action(data)) continue;
            toReturn.add(data);
        }
        return toReturn;
    }

    public static interface ToDoAction {
        public boolean action(Object var1);
    }
}

