/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;

public class LoggingUtil {
    public static boolean enableLogging(String fileName) {
        try {
            Class.forName("org.apache.log4j.Category");
            return LoggingUtil.enableLog4jLogging(fileName);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isLoggingConfigured() {
        return LoggingUtil.isLog4JConfigured();
    }

    public static boolean isLog4JConfigured() {
        try {
            Class.forName("org.apache.log4j.Category");
            return LoggingUtil.isLog4JConfigured0();
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isLog4JConfigured0() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> categoryClass = Class.forName("org.apache.log4j.Category");
        Method meth = categoryClass.getMethod("getRoot", new Class[0]);
        Object root = meth.invoke(null, new Object[0]);
        Method appendersMeth = categoryClass.getMethod("getAllAppenders", new Class[0]);
        Enumeration appenders = (Enumeration)appendersMeth.invoke(root, new Object[0]);
        return appenders.hasMoreElements();
    }

    private static boolean enableLog4jLogging(String fileName) throws Exception {
        Method configMethod;
        boolean logging = false;
        File cfgFile = new File(fileName);
        URL url = null;
        try {
            url = cfgFile.exists() ? cfgFile.toURL() : LoggingUtil.class.getResource("/log.xml");
            if (url == null) {
                url = LoggingUtil.class.getResource("log.xml");
            }
            Class<?> domConfiguratorClass = Class.forName("org.apache.log4j.xml.DOMConfigurator");
            configMethod = domConfiguratorClass.getMethod("configure", URL.class);
            configMethod.invoke(null, url);
            logging = true;
        }
        catch (Exception domConfiguratorClass) {
            // empty catch block
        }
        if (!logging) {
            Class<?> basicConfiguratorClass = Class.forName("org.apache.log4j.BasicConfigurator");
            configMethod = basicConfiguratorClass.getMethod("configure", new Class[0]);
            configMethod.invoke(null, new Object[0]);
            Log log = LogFactory.getLog("com.tplus.transform.util");
            log.warn("Unable to locate config file for logging. Logging will be done to the console.");
            logging = true;
        }
        return logging;
    }
}

