/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.Factory;
import com.tplus.transform.util.MapUtils;
import com.tplus.transform.util.Predicate;
import com.tplus.transform.util.ProxyMap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;

public class MapUtilsImpl
extends MapUtils {
    private static int debugIndent = 0;

    public static Object getObject(Map map, Object key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static String getString(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object key) {
        if (map != null) {
            Object answer = map.get(key);
            return MapUtilsImpl.toBoolean(answer);
        }
        return null;
    }

    public static Number getNumber(Map map, Object key) {
        if (map != null) {
            Object answer = map.get(key);
            return MapUtilsImpl.toNumber(answer);
        }
        return null;
    }

    public static Byte getByte(Map map, Object key) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Byte) {
            return (Byte)answer;
        }
        return answer.byteValue();
    }

    public static Short getShort(Map map, Object key) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Short) {
            return (Short)answer;
        }
        return answer.shortValue();
    }

    public static Integer getInteger(Map map, Object key) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return answer.intValue();
    }

    public static Long getLong(Map map, Object key) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return answer.longValue();
    }

    public static Float getFloat(Map map, Object key) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Float) {
            return (Float)answer;
        }
        return Float.valueOf(answer.floatValue());
    }

    public static Double getDouble(Map map, Object key) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return answer.doubleValue();
    }

    public static Map getMap(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null && answer instanceof Map) {
            return (Map)answer;
        }
        return null;
    }

    public static Object getObject(Map map, Object key, Object defaultValue) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer;
        }
        return defaultValue;
    }

    public static String getString(Map map, Object key, String defaultValue) {
        String answer = MapUtilsImpl.getString(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Boolean getBoolean(Map map, Object key, Boolean defaultValue) {
        Boolean answer = MapUtilsImpl.getBoolean(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Number getNumber(Map map, Object key, Number defaultValue) {
        Number answer = MapUtilsImpl.getNumber(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Byte getByte(Map map, Object key, Byte defaultValue) {
        Byte answer = MapUtilsImpl.getByte(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Short getShort(Map map, Object key, Short defaultValue) {
        Short answer = MapUtilsImpl.getShort(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Integer getInteger(Map map, Object key, Integer defaultValue) {
        Integer answer = MapUtilsImpl.getInteger(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Long getLong(Map map, Object key, Long defaultValue) {
        Long answer = MapUtilsImpl.getLong(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Float getFloat(Map map, Object key, Float defaultValue) {
        Float answer = MapUtilsImpl.getFloat(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Double getDouble(Map map, Object key, Double defaultValue) {
        Double answer = MapUtilsImpl.getDouble(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Map getMap(Map map, Object key, Map defaultValue) {
        Map answer = MapUtilsImpl.getMap(map, key);
        if (answer == null) {
            answer = defaultValue;
        }
        return answer;
    }

    public static Properties toProperties(Map map) {
        Properties answer = new Properties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                answer.put(key, value);
            }
        }
        return answer;
    }

    public static synchronized void verbosePrint(PrintStream out, Object key, Map map) {
        MapUtilsImpl.debugPrintIndent(out);
        out.println(key + " = ");
        MapUtilsImpl.debugPrintIndent(out);
        out.println("{");
        ++debugIndent;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String childKey = (String)entry.getKey();
            Object childValue = entry.getValue();
            if (childValue instanceof Map) {
                MapUtilsImpl.verbosePrint(out, childKey, (Map)childValue);
                continue;
            }
            MapUtilsImpl.debugPrintIndent(out);
            out.println(childKey + " = " + childValue);
        }
        --debugIndent;
        MapUtilsImpl.debugPrintIndent(out);
        out.println("}");
    }

    public static synchronized void debugPrint(PrintStream out, Object key, Map map) {
        MapUtilsImpl.debugPrintIndent(out);
        out.println(key + " = ");
        MapUtilsImpl.debugPrintIndent(out);
        out.println("{");
        ++debugIndent;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String childKey = (String)entry.getKey();
            Object childValue = entry.getValue();
            if (childValue instanceof Map) {
                MapUtilsImpl.verbosePrint(out, childKey, (Map)childValue);
                continue;
            }
            MapUtilsImpl.debugPrintIndent(out);
            String typeName = childValue != null ? childValue.getClass().getName() : null;
            out.println(childKey + " = " + childValue + " class: " + typeName);
        }
        --debugIndent;
        MapUtilsImpl.debugPrintIndent(out);
        out.println("}");
    }

    protected static void debugPrintIndent(PrintStream out) {
        for (int i = 0; i < debugIndent; ++i) {
            out.print("    ");
        }
    }

    protected static void logInfo(Exception e) {
        System.out.println("INFO: Exception: " + e);
    }

    public static final void safeAddToMap(Map map, Object key, Object value) throws NullPointerException {
        if (value == null) {
            map.put(key, "");
        } else {
            map.put(key, value);
        }
    }

    public static Map predicatedMap(Map map, Predicate keyPred, Predicate valuePred) {
        return new PredicatedMap(map, keyPred, valuePred);
    }

    public static Map fixedSizeMap(Map map) {
        return new FixedSizeMap(map);
    }

    public static Map lazyMap(Map map, Factory factory) {
        return new LazyMap(map, factory);
    }

    public static SortedMap predicatedSortedMap(SortedMap map, Predicate keyPred, Predicate valuePred) {
        return new PredicatedSortedMap(map, keyPred, valuePred);
    }

    public static SortedMap fixedSizeSortedMap(SortedMap map) {
        return new FixedSizeSortedMap(map);
    }

    public static SortedMap lazySortedMap(SortedMap map, Factory factory) {
        return new LazySortedMap(map, factory);
    }

    public static int getIntValue(Map map, String name, int defaultValue) {
        Integer integer = MapUtilsImpl.getInteger(map, name);
        if (integer != null) {
            return integer;
        }
        return defaultValue;
    }

    public static long getLongValue(Map map, String name, long defaultValue) {
        Long integer = MapUtilsImpl.getLong(map, name);
        if (integer != null) {
            return integer;
        }
        return defaultValue;
    }

    public static double getDoubleValue(Map map, String name, double defaultValue) {
        Double integer = MapUtilsImpl.getDouble(map, name);
        if (integer != null) {
            return integer;
        }
        return defaultValue;
    }

    public static boolean getBooleanValue(Map map, String name, boolean defaultValue) {
        Boolean integer = MapUtilsImpl.getBoolean(map, name);
        if (integer != null) {
            return integer;
        }
        return defaultValue;
    }

    static class LazySortedMap
    extends LazyMap
    implements SortedMap {
        public LazySortedMap(SortedMap m, Factory factory) {
            super(m, factory);
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object o1, Object o2) {
            return new LazySortedMap(this.getSortedMap().subMap(o1, o2), this.factory);
        }

        public SortedMap headMap(Object o1) {
            return new LazySortedMap(this.getSortedMap().headMap(o1), this.factory);
        }

        public SortedMap tailMap(Object o1) {
            return new LazySortedMap(this.getSortedMap().tailMap(o1), this.factory);
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }
    }

    static class FixedSizeSortedMap
    extends FixedSizeMap
    implements SortedMap {
        public FixedSizeSortedMap(SortedMap m) {
            super(m);
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object o1, Object o2) {
            return new FixedSizeSortedMap(this.getSortedMap().subMap(o1, o2));
        }

        public SortedMap headMap(Object o1) {
            return new FixedSizeSortedMap(this.getSortedMap().headMap(o1));
        }

        public SortedMap tailMap(Object o1) {
            return new FixedSizeSortedMap(this.getSortedMap().tailMap(o1));
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }
    }

    static class PredicatedSortedMap
    extends PredicatedMap
    implements SortedMap {
        public PredicatedSortedMap(SortedMap map, Predicate k, Predicate v) {
            super(map, k, v);
        }

        public Object firstKey() {
            return this.getSortedMap().firstKey();
        }

        public Object lastKey() {
            return this.getSortedMap().lastKey();
        }

        public Comparator comparator() {
            return this.getSortedMap().comparator();
        }

        public SortedMap subMap(Object o1, Object o2) {
            SortedMap sub = this.getSortedMap().subMap(o1, o2);
            return new PredicatedSortedMap(sub, this.keyPredicate, this.valuePredicate);
        }

        public SortedMap headMap(Object o1) {
            SortedMap sub = this.getSortedMap().headMap(o1);
            return new PredicatedSortedMap(sub, this.keyPredicate, this.valuePredicate);
        }

        public SortedMap tailMap(Object o1) {
            SortedMap sub = this.getSortedMap().tailMap(o1);
            return new PredicatedSortedMap(sub, this.keyPredicate, this.valuePredicate);
        }

        private SortedMap getSortedMap() {
            return (SortedMap)this.map;
        }
    }

    static class LazyMap
    extends ProxyMap {
        protected final Factory factory;

        public LazyMap(Map map, Factory factory) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
            if (factory == null) {
                throw new IllegalArgumentException("Factory must not be null");
            }
            this.factory = factory;
        }

        @Override
        public Object get(Object key) {
            if (!this.map.containsKey(key)) {
                Object value = this.factory.create();
                this.map.put(key, value);
                return value;
            }
            return this.map.get(key);
        }
    }

    static class FixedSizeMap
    extends ProxyMap {
        public FixedSizeMap(Map map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
        }

        @Override
        public Object put(Object key, Object value) {
            if (!this.map.containsKey(key)) {
                throw new IllegalArgumentException("Cannot put new key/value pair - List is fixed size");
            }
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map m) {
            for (Object o : m.keySet()) {
                if (this.map.containsKey(o)) continue;
                throw new IllegalArgumentException("Cannot put new key/value pair - List is fixed size");
            }
            this.map.putAll(m);
        }
    }

    static class PredicatedMapEntry
    implements Map.Entry {
        private final Map.Entry entry;
        private final Predicate predicate;

        public PredicatedMapEntry(Map.Entry entry, Predicate p) {
            if (entry == null) {
                throw new IllegalArgumentException("Map.Entry must not be null");
            }
            if (p == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.entry = entry;
            this.predicate = p;
        }

        @Override
        public boolean equals(Object o) {
            return this.entry.equals(o);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        public String toString() {
            return this.entry.toString();
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object o) {
            if (!this.predicate.evaluate(o)) {
                throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
            }
            return this.entry.setValue(o);
        }
    }

    static class PredicatedMapEntrySet
    extends CollectionWrapper
    implements Set {
        private final Predicate predicate;

        public PredicatedMapEntrySet(Set set, Predicate p) {
            super(set);
            this.predicate = p;
        }

        @Override
        public Iterator iterator() {
            final Iterator iterator = this.collection.iterator();
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Object next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return new PredicatedMapEntry(entry, PredicatedMapEntrySet.this.predicate);
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    static class CollectionWrapper
    implements Collection {
        protected final Collection collection;

        public CollectionWrapper(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.collection.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] o) {
            return this.collection.toArray(o);
        }

        public boolean add(Object o) {
            return this.collection.add(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.collection.remove(o);
        }

        public boolean containsAll(Collection c2) {
            return this.collection.containsAll(c2);
        }

        public boolean addAll(Collection c2) {
            return this.collection.addAll(c2);
        }

        public boolean removeAll(Collection c2) {
            return this.collection.removeAll(c2);
        }

        public boolean retainAll(Collection c2) {
            return this.collection.retainAll(c2);
        }

        @Override
        public void clear() {
            this.collection.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        public String toString() {
            return this.collection.toString();
        }
    }

    static class PredicatedMap
    extends ProxyMap {
        protected final Predicate keyPredicate;
        protected final Predicate valuePredicate;

        public PredicatedMap(Map map, Predicate keyPred, Predicate valuePred) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map must not be null");
            }
            if (keyPred == null) {
                throw new IllegalArgumentException("Key Predicate must not be null");
            }
            if (valuePred == null) {
                throw new IllegalArgumentException("Value Predicate must not be null");
            }
            this.keyPredicate = keyPred;
            this.valuePredicate = valuePred;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.validate(key, value);
            }
        }

        @Override
        public Object put(Object key, Object value) {
            this.validate(key, value);
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map m) {
            Iterator iterator = m.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.validate(key, value);
            }
            this.map.putAll(m);
        }

        @Override
        public Set entrySet() {
            return new PredicatedMapEntrySet(this.map.entrySet(), this.valuePredicate);
        }

        private void validate(Object key, Object value) {
            if (!this.keyPredicate.evaluate(key)) {
                throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
            }
            if (!this.valuePredicate.evaluate(value)) {
                throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
            }
        }
    }
}

