/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiHashMap
extends HashMap
implements Map {
    private static int sCount = 0;
    private String mName = null;

    public MultiHashMap() {
        this.setName();
    }

    public MultiHashMap(int initialCapacity) {
        super(initialCapacity);
        this.setName();
    }

    public MultiHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.setName();
    }

    public MultiHashMap(Map mapToCopy) {
        super(mapToCopy);
    }

    private void setName() {
        this.mName = "MultiMap-" + ++sCount;
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public Object put(Object key, Object value) {
        boolean results;
        if (value instanceof ArrayList) {
            return super.put(key, value);
        }
        ArrayList<Object> keyList = (ArrayList<Object>)super.get(key);
        if (keyList == null) {
            keyList = new ArrayList<Object>(10);
            super.put(key, keyList);
        }
        return (results = keyList.add(value)) ? value : null;
    }

    @Override
    public boolean containsValue(Object value) {
        Set pairs = super.entrySet();
        if (pairs == null) {
            return false;
        }
        for (Map.Entry pair : pairs) {
            Map.Entry keyValuePair = pair;
            ArrayList list = (ArrayList)keyValuePair.getValue();
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Set pairs = super.entrySet();
        Iterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            Map.Entry pair;
            Map.Entry keyValuePair = pair = iterator.next();
            ArrayList list = (ArrayList)keyValuePair.getValue();
            list.clear();
        }
        super.clear();
    }

    @Override
    public void putAll(Map mapToPut) {
        super.putAll(mapToPut);
    }

    @Override
    public Collection values() {
        ArrayList returnList = new ArrayList(super.size());
        Set pairs = super.entrySet();
        Iterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            Map.Entry pair;
            Map.Entry keyValuePair = pair = iterator.next();
            ArrayList list = (ArrayList)keyValuePair.getValue();
            Object[] values = list.toArray();
            Collections.addAll(returnList, values);
        }
        return returnList;
    }

    @Override
    public Object clone() {
        MultiHashMap obj = (MultiHashMap)super.clone();
        obj.mName = this.mName;
        return obj;
    }
}

