/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.util.Locale;

public class Os {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;

    public Os() {
    }

    public Os(String family) {
        this.setFamily(family);
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase(Locale.US);
    }

    public void setName(String name) {
        this.name = name.toLowerCase(Locale.US);
    }

    public void setArch(String arch) {
        this.arch = arch.toLowerCase(Locale.US);
    }

    public void setVersion(String version) {
        this.version = version.toLowerCase(Locale.US);
    }

    public boolean eval() {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return Os.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return Os.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                switch (family) {
                    case "windows": {
                        isFamily = OS_NAME.contains("windows");
                        break;
                    }
                    case "os/2": {
                        isFamily = OS_NAME.contains("os/2");
                        break;
                    }
                    case "netware": {
                        isFamily = OS_NAME.contains("netware");
                        break;
                    }
                    case "dos": {
                        isFamily = PATH_SEP.equals(";") && !Os.isFamily("netware");
                        break;
                    }
                    case "mac": {
                        isFamily = OS_NAME.contains("mac");
                        break;
                    }
                    case "tandem": {
                        isFamily = OS_NAME.contains("nonstop_kernel");
                        break;
                    }
                    case "unix": {
                        isFamily = PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x"));
                        break;
                    }
                    case "win9x": {
                        isFamily = Os.isFamily("windows") && (OS_NAME.contains("95") || OS_NAME.contains("98") || OS_NAME.contains("me") || OS_NAME.contains("ce"));
                        break;
                    }
                    case "z/os": {
                        isFamily = OS_NAME.contains("z/os") || OS_NAME.contains("os/390");
                        break;
                    }
                    case "os/400": {
                        isFamily = OS_NAME.contains("os/400");
                        break;
                    }
                    default: {
                        boolean bl = isFamily = family.equals("openvms") && OS_NAME.indexOf("openvms") > -1;
                    }
                }
            }
            if (name != null) {
                isName = name.equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }
}

