/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.POMInfo;
import com.tplus.transform.util.xml.XMLUtils;
import com.tplus.transform.util.xml.XMLWriterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class POMUtil {
    public static final String ARTIFACT_ID = "artifactId";
    public static final String GROUP_ID = "groupId";
    public static final String VERSION = "version";
    public static final String PACKAGING = "packaging";
    public static final String DESCRIPTION = "description";
    public static final String DEPENDENCY = "dependency";
    public static final String PARENT = "parent";
    public static final String POM_XML_FILE = "pom.xml";
    public static final String PROJECT = "project";

    public static POMInfo readPOM(URL url) throws IOException, SAXException, ParserConfigurationException {
        InputStream inputStream = url.openConnection().getInputStream();
        if (inputStream != null) {
            return POMUtil.readPOM(inputStream);
        }
        return null;
    }

    private static POMInfo readPOM(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        POMInfo info = new POMInfo();
        Document document = XMLUtils.createDocument(inputStream);
        Element documentElement = document.getDocumentElement();
        String groupId = XMLUtils.getSingleChildElementValue(documentElement, GROUP_ID);
        String artifactId = XMLUtils.getSingleChildElementValue(documentElement, ARTIFACT_ID);
        String version = XMLUtils.getSingleChildElementValue(documentElement, VERSION);
        Element parent = XMLUtils.getSingleChildElement(documentElement, PARENT);
        if (parent != null) {
            String parentGroupId = XMLUtils.getSingleChildElementValue(parent, GROUP_ID);
            String parentArtifactId = XMLUtils.getSingleChildElementValue(parent, ARTIFACT_ID);
            String parentVersion = XMLUtils.getSingleChildElementValue(parent, VERSION);
            parentGroupId = parentGroupId != null ? parentGroupId : "unknown";
            parentArtifactId = parentArtifactId != null ? parentArtifactId : "unknown";
            parentVersion = parentVersion != null ? parentVersion : "0.0";
            groupId = groupId != null ? groupId : parentGroupId;
            artifactId = artifactId != null ? artifactId : parentArtifactId;
            version = version != null ? version : parentVersion;
        }
        info.setGroupId(groupId);
        info.setArtifactId(artifactId);
        info.setVersion(version);
        info.setPackaging(XMLUtils.getSingleChildElementValue(documentElement, PACKAGING));
        info.setClassifier(XMLUtils.getSingleChildElementValue(documentElement, "classifier"));
        info.setDescription(XMLUtils.getSingleChildElementValue(documentElement, DESCRIPTION));
        NodeList dependencies = XMLUtils.getChildElementsByTagName(documentElement, DEPENDENCY);
        for (int i = 0; i < dependencies.getLength(); ++i) {
            Element item = (Element)dependencies.item(i);
            String groupId2 = XMLUtils.getSingleChildElementValue(item, GROUP_ID);
            String artifactId2 = XMLUtils.getSingleChildElementValue(item, ARTIFACT_ID);
            String version2 = XMLUtils.getSingleChildElementValue(item, VERSION);
            POMInfo dependency = new POMInfo();
            dependency.setGroupId(groupId2);
            dependency.setArtifactId(artifactId2);
            dependency.setVersion(version2);
            info.getDependencies().add(dependency);
        }
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static POMInfo readPOMFromJar(String fileName) {
        if (!new File(fileName).exists()) return null;
        try {
            SafeFile.doFileCheck(fileName);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(fileName));){
                ZipEntry zipEntry = null;
                while ((zipEntry = zin.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!entryName.endsWith(POM_XML_FILE)) continue;
                    POMInfo pOMInfo = POMUtil.readPOM(zin);
                    return pOMInfo;
                }
                zin.close();
                return null;
            }
            catch (ParserConfigurationException | SAXException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractPOMFromJar(String fileName, String outputFile) {
        if (!new File(fileName).exists()) return false;
        try {
            SafeFile.doFileCheck(fileName);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(fileName));){
                ZipEntry zipEntry = null;
                while ((zipEntry = zin.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!entryName.endsWith(POM_XML_FILE)) continue;
                    IOUtil.copyStreams(zin, new FileOutputStream(outputFile), true);
                    boolean bl = true;
                    return bl;
                }
                zin.close();
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        POMUtil.extractPOMFromJar(args[0], args[1]);
    }

    public static void createPOMFile(POMInfo pomInfo, String pomName) throws IOException {
        XMLWriterUtil xmlWriterUtil = new XMLWriterUtil();
        String toRet = xmlWriterUtil.startTag(PROJECT) + xmlWriterUtil.tagValue("modelVersion", "4.0.0") + xmlWriterUtil.tagValue(GROUP_ID, pomInfo.getGroupId()) + xmlWriterUtil.tagValue(ARTIFACT_ID, pomInfo.getArtifactId()) + xmlWriterUtil.tagValue(VERSION, pomInfo.getVersion()) + xmlWriterUtil.tagValue(DESCRIPTION, pomInfo.getDescription()) + xmlWriterUtil.tagValue(PACKAGING, pomInfo.getPackaging()) + xmlWriterUtil.endTag(PROJECT);
        IOUtil.write(pomName, toRet);
    }
}

