/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PrimitiveDateFormat {
    static final String[] ab_day_nm = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] day_nm = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    static final String[] ab_month_nm = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static final String[] month_nm = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    static int getMonth3Char(String month3Str, int start) {
        for (int i = 0; i < 12; ++i) {
            if (!month3Str.regionMatches(true, start, ab_month_nm[i], 0, 3)) continue;
            return i;
        }
        return -1;
    }

    static int getMonthFull(String monthNStr, int start) {
        for (int i = 0; i < 12; ++i) {
            if (!monthNStr.regionMatches(true, start, ab_month_nm[i], 0, ab_month_nm[i].length())) continue;
            return i;
        }
        return -1;
    }

    static int toInt(String ptr, int start, int length) {
        return Integer.parseInt(ptr.substring(start, start + length));
    }

    public static Date parseDate(String dateStr, String format) throws ParseException {
        int year = 70;
        int month = 0;
        int date = 1;
        int hrs = 0;
        int mins = 0;
        int secs = 0;
        int millis = 0;
        int i = 0;
        int j = 0;
        block9: while (i < format.length()) {
            char c = format.charAt(i);
            ++i;
            switch (c) {
                case 'y': {
                    int ycount = 1;
                    while (i < format.length() && format.charAt(i) == 'y') {
                        ++ycount;
                        ++i;
                    }
                    if (ycount < 2) {
                        throw new ParseException("Illegal year pattern in '" + format + "'. At least 2 y's expected.", j);
                    }
                    if (ycount == 3 || ycount > 4) {
                        throw new ParseException("Illegal year pattern in '" + format + "'. Only patterns 'yy' and 'yyyy' are supported.", j);
                    }
                    if (ycount >= 4) {
                        year = PrimitiveDateFormat.toInt(dateStr, j, 4);
                        year -= 1900;
                        j += 4;
                        continue block9;
                    }
                    year = PrimitiveDateFormat.toInt(dateStr, j, 2);
                    year = year < 70 ? (year += 2000) : (year += 1900);
                    year -= 1900;
                    j += 2;
                    continue block9;
                }
                case 'M': {
                    int month_index;
                    int mcount = 1;
                    while (i < format.length() && format.charAt(i) == 'M') {
                        ++mcount;
                        ++i;
                    }
                    if (mcount < 2) {
                        throw new ParseException("Illegal month pattern in '" + format + "'. At least 2 M's expected.", j);
                    }
                    if (mcount == 2) {
                        month = PrimitiveDateFormat.toInt(dateStr, j, 2) - 1;
                        j += 2;
                        continue block9;
                    }
                    if (mcount == 3) {
                        month_index = PrimitiveDateFormat.getMonth3Char(dateStr, j);
                        if (month_index == -1) {
                            throw new ParseException("Error parsing month part of date string, expected pattern " + format + " found " + dateStr, j);
                        }
                        month = month_index;
                        j += 3;
                        continue block9;
                    }
                    month_index = PrimitiveDateFormat.getMonthFull(dateStr, j);
                    if (month_index == -1) {
                        throw new ParseException("Error parsing month part of date string, expected pattern " + format + " found " + dateStr, j);
                    }
                    month = month_index;
                    j += ab_month_nm[month_index].length();
                    continue block9;
                }
                case 'd': {
                    int dcount = 1;
                    while (i < format.length() && format.charAt(i) == 'd') {
                        ++dcount;
                        ++i;
                    }
                    if (dcount != 2) {
                        throw new ParseException("Illegal date pattern in '" + format + "'. Only pattern 'dd' is supported.", j);
                    }
                    date = PrimitiveDateFormat.toInt(dateStr, j, 2);
                    j += 2;
                    continue block9;
                }
                case 'H': {
                    int hcount = 1;
                    while (i < format.length() && format.charAt(i) == 'H') {
                        ++hcount;
                        ++i;
                    }
                    if (hcount != 2) {
                        throw new ParseException("Illegal hour pattern in '" + format + "'. Only pattern 'HH' is supported.", j);
                    }
                    hrs = PrimitiveDateFormat.toInt(dateStr, j, 2);
                    j += 2;
                    continue block9;
                }
                case 'm': {
                    int mcount = 1;
                    while (i < format.length() && format.charAt(i) == 'm') {
                        ++mcount;
                        ++i;
                    }
                    if (mcount != 2) {
                        throw new ParseException("Illegal minute pattern in '" + format + "'. Only pattern 'mm' is supported.", j);
                    }
                    mins = PrimitiveDateFormat.toInt(dateStr, j, 2);
                    j += 2;
                    continue block9;
                }
                case 'S': {
                    int scount = 1;
                    while (i < format.length() && format.charAt(i) == 'S') {
                        ++scount;
                        ++i;
                    }
                    if (scount > 3) {
                        throw new ParseException("Illegal milli-seconds pattern in '" + format + "'. Only pattern 'SSS' is supported.", j);
                    }
                    millis = PrimitiveDateFormat.toInt(dateStr, j, 3);
                    j += 3;
                    continue block9;
                }
                case 's': {
                    int scount = 1;
                    while (i < format.length() && format.charAt(i) == 's') {
                        ++scount;
                        ++i;
                    }
                    if (scount != 2) {
                        throw new ParseException("Illegal seconds pattern in '" + format + "'. Only pattern 'ss' is supported.", j);
                    }
                    secs = PrimitiveDateFormat.toInt(dateStr, j, 2);
                    j += 2;
                    continue block9;
                }
            }
            if (c == dateStr.charAt(j)) {
                ++j;
                continue;
            }
            throw new ParseException("Error parsing date string, expected pattern " + format + " found " + dateStr, j);
        }
        Date t = new Date(year, month, date, hrs, mins, secs);
        if (millis > 0) {
            t.setTime(t.getTime() + (long)millis);
        }
        return t;
    }

    static void copyTest(int size) {
        char[] src = new char[size];
        char[] dest = new char[size];
        int count = 1000000;
        long s1 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            PrimitiveDateFormat.copy1(src, dest);
        }
        long e1 = System.currentTimeMillis();
        long s2 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            PrimitiveDateFormat.copy2(src, dest);
        }
        long e2 = System.currentTimeMillis();
        System.out.println("SIZE = " + size + "**********************");
        double v1 = (double)(count * 1000) / (double)(e1 - s1);
        System.out.println("SysARRAY = " + v1);
        double v2 = (double)(count * 1000) / (double)(e2 - s2);
        System.out.println("Manual = " + v2);
        System.out.println("Diff = " + v2 / v1);
    }

    static void copy1(char[] src, char[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    static void copy2(char[] src, char[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length - 1 + 1);
    }

    public static void cmtmain(String[] args) throws ParseException {
        PrimitiveDateFormat.copyTest(10);
        PrimitiveDateFormat.copyTest(10);
        PrimitiveDateFormat.copyTest(20);
        PrimitiveDateFormat.copyTest(30);
        PrimitiveDateFormat.copyTest(40);
        PrimitiveDateFormat.copyTest(50);
        PrimitiveDateFormat.copyTest(60);
        PrimitiveDateFormat.copyTest(70);
        PrimitiveDateFormat.assertEquals("19031010", "yyyyMMdd");
        PrimitiveDateFormat.assertEquals("20031212", "yyyyMMdd");
        PrimitiveDateFormat.assertEquals("20030101", "yyyyMMdd");
        PrimitiveDateFormat.assertEquals("20030101-:-12:20:24", "yyyyMMdd-:-HH:mm:ss");
        PrimitiveDateFormat.timing("20030101-:-12:20:24", "yyyyMMdd-:-HH:mm:ss");
    }

    static void assertEquals(String dateStr, String pattern) throws ParseException {
        SimpleDateFormat df;
        Date date2;
        Date date1 = PrimitiveDateFormat.parseDate(dateStr, pattern);
        if (!date1.equals(date2 = (df = new SimpleDateFormat(pattern)).parse(dateStr))) {
            System.out.println("Parse error " + dateStr + "=" + date1 + ", " + date2);
        }
    }

    static void timing(String dateStr, String pattern) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        int count = 100000;
        long s2 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            Date date = df.parse(dateStr);
        }
        long e2 = System.currentTimeMillis();
        System.gc();
        long s1 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            Date date = PrimitiveDateFormat.parseDate(dateStr, pattern);
        }
        long e1 = System.currentTimeMillis();
        System.out.println("V_TIME = " + (double)(count * 1000) / (double)(e1 - s1));
        System.out.println("D_TIME = " + (double)(count * 1000) / (double)(e2 - s2));
    }
}

