/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    public static Log log = LogFactory.getLog("com.tplus.transform.design");

    public static String getResourceMessage(String code, Object elm, Object location) {
        List bundles = ResourceManager.getResouceBundles(location);
        bundles.addAll(ResourceManager.getResouceBundles(elm));
        for (Object bundle : bundles) {
            ResourceBundle rsrc = (ResourceBundle)bundle;
            try {
                String toRet = rsrc.getString(code);
                return toRet;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        log.error("Missing resource " + code + " in " + elm.getClass() + ":" + location.getClass());
        return null;
    }

    static List getResouceBundles(Object location) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        for (Class<?> cls = location.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            ResourceBundle rsrc = ResourceManager.getResouceBundle(cls);
            if (rsrc == null) continue;
            bundles.add(rsrc);
        }
        return bundles;
    }

    public static ResourceBundle getResouceBundle(Class cls) {
        String packageName = ResourceManager.getPackageName(cls);
        try {
            ClassLoader loader = cls.getClassLoader();
            if (loader == null) {
                loader = ResourceManager.class.getClassLoader();
            }
            ResourceBundle rsrc = ResourceBundle.getBundle(packageName + ".messages", Locale.getDefault(), loader);
            return rsrc;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String getPackageName(Class cls) {
        String className = cls.getName();
        String packageName = ResourceManager.getPackageName(className);
        return packageName;
    }

    private static String getPackageName(String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        return packageName;
    }
}

