/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.security.DefaultEncoder;
import com.tplus.transform.util.ExecUtil;
import com.tplus.transform.util.ProcessListener;
import com.tplus.transform.util.Streamer;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class RunProcess
implements Runnable {
    static Log log = LogFactory.getLog("com.tplus.transform.util");
    private String[] exec;
    private PrintWriter out;
    private PrintWriter err;
    private ProcessListener listener;
    private String initialDir;
    private Process process;
    int exitCode = -100;

    public RunProcess(String fullStr, PrintWriter out, PrintWriter err, ProcessListener listener) {
        this(ExecUtil.splitCommandLine(fullStr), out, err, listener);
    }

    public RunProcess(String[] exec, PrintWriter out, PrintWriter err, ProcessListener listener) {
        this.exec = exec;
        this.out = out;
        this.err = err;
        this.listener = listener;
    }

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setInitialDir(String initialDir) {
        this.initialDir = initialDir;
    }

    protected boolean isContained(char[] haystack, char c) {
        for (char aHaystack : haystack) {
            if (c != aHaystack) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            Runtime r = Runtime.getRuntime();
            File initDir = null;
            if (this.initialDir != null) {
                initDir = new File(this.initialDir);
            }
            this.process = r.exec(this.exec, null, initDir);
            if (this.listener != null) {
                this.listener.notifyProcessStart();
            }
            InputStream errin = this.process.getErrorStream();
            InputStream outin = this.process.getInputStream();
            Streamer errstream = new Streamer(errin, this.err);
            Streamer outstream = new Streamer(outin, this.out);
            outstream.start();
            errstream.start();
            this.exitCode = this.process.waitFor();
            errstream.flush();
            outstream.flush();
            if (this.listener != null) {
                this.listener.notifyProcessEnd(this.exitCode);
            }
        }
        catch (IOException e) {
            this.err.println("Error executing external program '" + this.exec[0] + "'." + e.getMessage());
        }
        catch (Exception e) {
            this.err.println("Error executing external program '" + this.exec[0] + "'." + e.getMessage());
            e.printStackTrace(this.err);
            log.debug("Stack Trace : ", e);
        }
    }

    private void sanitize() {
        DefaultEncoder defaultEncoder = new DefaultEncoder();
        for (int i = 1; i < this.exec.length; ++i) {
            String param = this.exec[i];
            this.exec[i] = defaultEncoder.encodeForOS(DefaultEncoder.getOSCodec(), param);
        }
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

