/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.ISection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SectionPrefImpl
implements ISection {
    private Preferences preferences;

    public SectionPrefImpl(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public String getSectionName() {
        return this.preferences.name();
    }

    @Override
    public String getKeyValue(String key, String defaultValue) {
        return this.preferences.get(key, defaultValue);
    }

    @Override
    public int getKeyIntValue(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    @Override
    public long getKeyLongValue(String key, long defaultValue) {
        return this.preferences.getLong(key, defaultValue);
    }

    @Override
    public boolean getKeyBoolValue(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    @Override
    public void addKeyValue(String key, String val) {
        this.preferences.put(key, val);
    }

    @Override
    public void addKeyIntValue(String key, int value) {
        this.preferences.putInt(key, value);
    }

    @Override
    public void addKeyBoolValue(String key, boolean val) {
        this.preferences.putBoolean(key, val);
    }

    @Override
    public boolean removeKeyValue(String key) {
        this.preferences.remove(key);
        return true;
    }

    @Override
    public void removeAllKeys() {
        String[] strings;
        for (String string : strings = this.getKeys()) {
            this.preferences.remove(string);
        }
    }

    @Override
    public int getCount() {
        return this.getKeys().length;
    }

    @Override
    public String[] getKeys() {
        try {
            return this.preferences.keys();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    @Override
    public String[] getValues() {
        String[] keys = this.getKeys();
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            values[i] = this.preferences.get(key, "");
        }
        return values;
    }
}

