/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.ComparableVersion;
import com.tplus.transform.util.StringUtils;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Serializable,
Cloneable,
Comparable {
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer microVersion;
    private String qualifier;
    private ComparableVersion comparableVersion;
    private String versionStr;
    private String canonicalVersionStr;
    private static final Pattern FILE_BLACKLIST_PAT = SafeFile.getFileBlacklistPat();

    public Version(String versionStr) {
        if (versionStr == null) {
            versionStr = "";
        }
        this.versionStr = versionStr;
        this.parseVersion(this.versionStr);
        this.comparableVersion = new ComparableVersion(versionStr);
    }

    private void parseVersion(String version) {
        String part1;
        int index = version.indexOf(45);
        String part2 = null;
        if (index < 0) {
            part1 = version;
        } else {
            part1 = version.substring(0, index);
            part2 = version.substring(index + 1);
        }
        if (part2 != null) {
            this.qualifier = part2;
        }
        if (!part1.contains(".")) {
            try {
                this.majorVersion = Integer.valueOf(part1);
            }
            catch (NumberFormatException e) {
                this.qualifier = version;
            }
        } else {
            boolean fallback = false;
            StringTokenizer tok = new StringTokenizer(part1, ".");
            if (!tok.hasMoreTokens()) {
                return;
            }
            String currentToken = tok.nextToken();
            try {
                this.majorVersion = Integer.parseInt(currentToken);
                if (tok.hasMoreTokens()) {
                    currentToken = tok.nextToken();
                    this.minorVersion = Integer.parseInt(currentToken);
                }
                if (tok.hasMoreTokens()) {
                    currentToken = tok.nextToken();
                    this.microVersion = Integer.parseInt(currentToken);
                }
                StringBuilder qualifierBuilder = new StringBuilder();
                boolean hasMoreToken = tok.hasMoreTokens();
                while (hasMoreToken) {
                    qualifierBuilder.append(tok.nextToken());
                    hasMoreToken = tok.hasMoreTokens();
                    if (!hasMoreToken) continue;
                    qualifierBuilder.append('.');
                }
                if (qualifierBuilder.length() > 0) {
                    this.qualifier = qualifierBuilder.toString();
                }
                if (part1.contains("..") || part1.startsWith(".") || part1.endsWith(".")) {
                    fallback = true;
                }
            }
            catch (NumberFormatException e) {
                fallback = true;
            }
            if (fallback) {
                this.qualifier = version;
                this.majorVersion = null;
                this.minorVersion = null;
                this.microVersion = null;
            } else if (StringUtils.isNotEmpty(part2) && StringUtils.isNotEmpty(this.qualifier) && !StringUtils.equals(this.qualifier, part2)) {
                this.qualifier = this.qualifier + "-" + part2;
            }
        }
    }

    public Version(String versionStr, boolean canonicalVersion) {
        this(versionStr);
    }

    public int getBranchIndexOf(Version base) {
        String numberPart;
        if (this.versionStr.startsWith(base.versionStr) && this.versionStr.length() > base.versionStr.length() && (numberPart = this.versionStr.substring(base.versionStr.length() + 1)).indexOf(46) == -1) {
            return Integer.parseInt(numberPart);
        }
        return 0;
    }

    public int compareTo(Object o) {
        if (o instanceof Version) {
            return this.comparableVersion.compareTo(((Version)o).comparableVersion);
        }
        return this.toString().compareTo(o.toString());
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (o instanceof Version) {
            Version version = (Version)o;
            return this.compareTo(version) == 0;
        }
        return false;
    }

    public String getCanonicalVersion() {
        if (this.canonicalVersionStr == null) {
            this.canonicalVersionStr = this.prepareCanonicalVersion();
        }
        return this.canonicalVersionStr;
    }

    private String prepareCanonicalVersion() {
        String majorStr = Integer.valueOf(this.getMajorVersion()).toString();
        int major = majorStr.length();
        String minorStr = Integer.valueOf(this.getMinorVersion()).toString();
        int minor = minorStr.length();
        String microStr = Integer.valueOf(this.getMicroVersion()).toString();
        int micro = microStr.length();
        int maxDigit = micro > (major > minor ? major : minor) ? micro : (major > minor ? major : minor);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.lpad(majorStr, '0', maxDigit));
        if (this.minorVersion != null) {
            stringBuilder.append('.');
            stringBuilder.append(StringUtils.lpad(minorStr, '0', maxDigit));
        }
        if (this.microVersion != null) {
            stringBuilder.append('.');
            stringBuilder.append(StringUtils.lpad(microStr, '0', maxDigit));
        }
        if (this.qualifier != null) {
            stringBuilder.append('.');
            stringBuilder.append(this.qualifier);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.versionStr;
    }

    public Version getNextMajorVersion() {
        return new Version(Integer.toString(this.getMajorVersion() + 1));
    }

    public Version getNextMinorVersion() {
        return new Version(Integer.toString(this.getMajorVersion()) + "." + (this.getMinorVersion() + 1));
    }

    public Version getNextMicroVersion() {
        return new Version(Integer.toString(this.getMajorVersion()) + "." + this.getMinorVersion() + "." + (this.getMicroVersion() + 1));
    }

    public int getMajorVersion() {
        return this.majorVersion == null ? 0 : this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion == null ? 0 : this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion == null ? 0 : this.microVersion;
    }

    public boolean isMajorVersion() {
        return this.majorVersion != null;
    }

    public int compareTo(Version info, boolean withPatch) {
        return this.compareTo(info);
    }

    public void validate() {
        if (this.versionStr.equals("")) {
            throw new RuntimeException("Version cannot be empty");
        }
        if (this.majorVersion == null && this.minorVersion == null && this.microVersion == null && this.qualifier == null) {
            throw new RuntimeException("Not a valid version number");
        }
        Matcher matcher = FILE_BLACKLIST_PAT.matcher(this.versionStr);
        if (matcher.find()) {
            throw new RuntimeException("Invalid version qualifier. Version qualifier cannot contain [<, >, /, \\, ?, *, |, :]");
        }
    }

    public String toOSGIVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.majorVersion != null) {
            stringBuilder.append(this.majorVersion);
            if (this.minorVersion != null) {
                stringBuilder.append(".");
                stringBuilder.append(this.minorVersion);
                if (this.microVersion != null) {
                    stringBuilder.append(".");
                    stringBuilder.append(this.microVersion);
                    if (this.qualifier != null) {
                        stringBuilder.append(".");
                        Version.cleanupModifier(stringBuilder, this.qualifier);
                    }
                } else if (this.qualifier != null) {
                    stringBuilder.append(".0.");
                    Version.cleanupModifier(stringBuilder, this.qualifier);
                } else {
                    stringBuilder.append(".0");
                }
            } else if (this.qualifier != null) {
                stringBuilder.append(".0.0.");
                Version.cleanupModifier(stringBuilder, this.qualifier);
            } else {
                stringBuilder.append(".0.0");
            }
        } else {
            stringBuilder.append("0.0.0.");
            Version.cleanupModifier(stringBuilder, this.versionStr);
        }
        return stringBuilder.toString();
    }

    private static void cleanupModifier(StringBuilder stringBuilder, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
    }

    public static Version createVersion(String version) {
        if (version != null && version.length() > 0) {
            return new Version(version);
        }
        return null;
    }
}

