/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class VolanteEncryptedXMLSelection
implements Transferable,
ClipboardOwner {
    private static final String VOLANTE_ENRYPTED_XML_MIME_TYPE = "application/x-volante-enrypted-xml;class=com.tplus.transform.io.EncInputStream";
    private static final String VOLANTE_ENRYPTED_TEXT_MIME_TYPE = "application/x-volante-enrypted-text;class=com.tplus.transform.io.EncInputStream";
    public static DataFlavor ENCRYPTED_XML_FLAVOR;
    public static DataFlavor ENCRYPTED_TEXT_FLAVOR;
    public static DataFlavor XML_FLAVOR;
    private static final DataFlavor[] flavors;
    private byte[] encryptedXML;
    private byte[] encryptedText;

    public VolanteEncryptedXMLSelection(byte[] encryptedXML) {
        this.encryptedXML = encryptedXML;
        this.encryptedText = null;
    }

    public VolanteEncryptedXMLSelection(byte[] encryptedXML, byte[] encryptedText) {
        this.encryptedXML = encryptedXML;
        this.encryptedText = encryptedText;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> toRet = new ArrayList<DataFlavor>();
        if (this.encryptedXML != null) {
            toRet.add(ENCRYPTED_XML_FLAVOR);
        }
        if (this.encryptedText != null) {
            toRet.add(ENCRYPTED_TEXT_FLAVOR);
        }
        return toRet.toArray(new DataFlavor[toRet.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flavor1 : flavors = this.getTransferDataFlavors()) {
            if (!flavor.equals(flavor1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.encryptedXML != null && flavor.equals(ENCRYPTED_XML_FLAVOR)) {
            return new ByteArrayInputStream(this.encryptedXML);
        }
        if (this.encryptedText != null && flavor.equals(ENCRYPTED_TEXT_FLAVOR)) {
            return new ByteArrayInputStream(this.encryptedText);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        XML_FLAVOR = DataFlavor.stringFlavor;
        try {
            ENCRYPTED_XML_FLAVOR = new DataFlavor(VOLANTE_ENRYPTED_XML_MIME_TYPE);
            ENCRYPTED_TEXT_FLAVOR = new DataFlavor(VOLANTE_ENRYPTED_TEXT_MIME_TYPE);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        flavors = new DataFlavor[]{ENCRYPTED_XML_FLAVOR, ENCRYPTED_TEXT_FLAVOR};
    }
}

