/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.csv;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.csv.CSVException;
import com.tplus.transform.util.csv.Tokenizer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVParser {
    private CSVParser() {
    }

    public static List parse(String fileName) throws IllegalArgumentException, FileNotFoundException, CSVException {
        return CSVParser.parse(fileName, ",");
    }

    public static List parse(String fileName, String fieldDelimiter) throws IllegalArgumentException, FileNotFoundException, CSVException {
        if (fileName == null && (fieldDelimiter == null || fieldDelimiter.length() != 1)) {
            throw new IllegalArgumentException("All the arguments are illegal");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (fieldDelimiter == null || fieldDelimiter.length() != 1) {
            throw new IllegalArgumentException("Illegal field delimiter");
        }
        SafeFile.doFileCheck(fileName);
        FileInputStream fis = new FileInputStream(fileName);
        return CSVParser.parse(fis, fieldDelimiter);
    }

    public static List parse(InputStream in) throws IllegalArgumentException, CSVException {
        return CSVParser.parse(in, ",");
    }

    public static List parse(InputStream in, String fieldDelimiter) throws IllegalArgumentException, CSVException, CSVException {
        return CSVParser.parse(new InputStreamReader(in), fieldDelimiter);
    }

    public static List parse(Reader isr, String fieldDelimiter) throws IllegalArgumentException, CSVException {
        if (isr == null && (fieldDelimiter == null || fieldDelimiter.length() != 1)) {
            throw new IllegalArgumentException("All the arguments are illegal");
        }
        if (isr == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        if (fieldDelimiter == null || fieldDelimiter.length() != 1) {
            throw new IllegalArgumentException("Illegal field Delimiter");
        }
        ArrayList<String[]> csvElements = new ArrayList<String[]>(10);
        String line = null;
        int lineNo = 0;
        BufferedReader br = new BufferedReader(isr);
        int lastSize = 10;
        try {
            while ((line = br.readLine()) != null) {
                List csvLine = CSVParser.tokenizeLine(line, fieldDelimiter, ++lineNo, lastSize);
                csvElements.add(csvLine.toArray(new String[csvLine.size()]));
                lastSize = csvLine.size();
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new CSVException("Error in read line ", ioe);
        }
        return csvElements;
    }

    public static List tokenizeLine(String line, String fieldDelimiter) throws CSVException {
        return CSVParser.tokenizeLine(line, fieldDelimiter, 1, 10);
    }

    private static List tokenizeLine(String line, String fieldDelimiter, int lineNo, int lastSize) throws CSVException {
        ArrayList<String> csvLine = new ArrayList<String>(lastSize);
        Tokenizer tokenizer = new Tokenizer();
        tokenizer.setString(line, fieldDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String token = null;
            try {
                token = tokenizer.nextToken();
            }
            catch (CSVException te) {
                throw new CSVException(te.getMessage() + " at Line No: " + lineNo);
            }
            csvLine.add(token);
        }
        return csvLine;
    }
}

