/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.csv;

import com.tplus.transform.util.csv.CSVException;

class Tokenizer {
    private int linePtr;
    private String line;
    private boolean delimiterAtEnd;
    private char fieldDelimiter;

    public void setString(String string) throws IllegalArgumentException {
        this.setString(string, ",");
    }

    public void setString(String string, String fieldDelimiter) throws IllegalArgumentException {
        if (string == null && (fieldDelimiter == null || fieldDelimiter.length() != 1)) {
            throw new IllegalArgumentException("Both the arguments are illegal");
        }
        if (string == null) {
            throw new IllegalArgumentException("The string argument is null");
        }
        if (fieldDelimiter == null || fieldDelimiter.length() != 1) {
            throw new IllegalArgumentException("Illegal field delimiter");
        }
        this.line = string.trim();
        this.linePtr = 0;
        this.fieldDelimiter = fieldDelimiter.charAt(0);
        this.delimiterAtEnd = false;
    }

    public boolean hasMoreTokens() {
        if (this.eol()) {
            return this.delimiterAtEnd;
        }
        return true;
    }

    public String nextToken() throws CSVException {
        if (this.delimiterAtEnd) {
            this.delimiterAtEnd = false;
            return "";
        }
        boolean success = this.positionAtNonSpace();
        if (success) {
            if (this.line.charAt(this.linePtr) == this.fieldDelimiter) {
                this.handleFieldDelimiter();
                return "";
            }
            String token = "";
            if (this.line.charAt(this.linePtr) == '\"') {
                ++this.linePtr;
                token = this.extractQuotedToken();
            } else {
                token = this.extractUnquotedToken();
            }
            return token;
        }
        return "";
    }

    private void handleFieldDelimiter() {
        ++this.linePtr;
        if (this.eol()) {
            this.delimiterAtEnd = true;
        }
    }

    private boolean positionAtNonSpace() {
        boolean nonSpaceFound = false;
        while (!this.eol()) {
            if (this.line.charAt(this.linePtr) == ' ' || this.fieldDelimiter != '\t' && this.line.charAt(this.linePtr) == '\t') {
                ++this.linePtr;
                continue;
            }
            nonSpaceFound = true;
            break;
        }
        return nonSpaceFound;
    }

    private String extractUnquotedToken() {
        String token = "";
        int delimiterIdx = this.line.indexOf(this.fieldDelimiter, this.linePtr);
        if (delimiterIdx == -1) {
            token = this.line.substring(this.linePtr);
            this.linePtr = this.line.length();
        } else {
            token = this.line.substring(this.linePtr, delimiterIdx);
            this.linePtr = delimiterIdx;
            this.handleFieldDelimiter();
        }
        return token;
    }

    private String extractQuotedToken() throws CSVException {
        String token = "";
        while (!this.eol()) {
            int quoteIdx = this.line.indexOf(34, this.linePtr);
            if (quoteIdx == -1) {
                throw new CSVException("Closing quote not found");
            }
            if (quoteIdx == this.line.length() - 1) {
                token = token + this.line.substring(this.linePtr, quoteIdx);
                this.linePtr = quoteIdx + 1;
                break;
            }
            if (this.line.charAt(quoteIdx + 1) == '\"') {
                token = token + this.line.substring(this.linePtr, quoteIdx) + '\"';
                this.linePtr = quoteIdx + 2;
                if (!this.eol()) continue;
                throw new CSVException("EOL reached before closing quote found");
            }
            token = token + this.line.substring(this.linePtr, quoteIdx);
            this.linePtr = quoteIdx + 1;
            this.positionAtNextToken();
            break;
        }
        return token;
    }

    private void positionAtNextToken() throws CSVException {
        boolean success = this.positionAtNonSpace();
        if (success) {
            if (this.line.charAt(this.linePtr) == this.fieldDelimiter) {
                this.handleFieldDelimiter();
            } else {
                throw new CSVException("Improper quoted token");
            }
        }
    }

    private boolean eol() {
        return this.linePtr >= this.line.length();
    }

    public static String decodeToken(String token) {
        String retVal = "";
        int startIdx = 0;
        boolean isQuoted = false;
        while (true) {
            int quoteIdx;
            if ((quoteIdx = token.indexOf("\"", startIdx)) == -1) {
                if (!isQuoted) break;
                retVal = "\"" + retVal + token.substring(startIdx) + "\"";
                return retVal;
            }
            isQuoted = true;
            retVal = retVal + token.substring(startIdx, quoteIdx) + "\"\"";
            startIdx = quoteIdx + 1;
        }
        if (token.indexOf(44) == -1) {
            return token;
        }
        return "\"" + token + "\"";
    }

    public static void cmtmain(String[] args) throws Exception {
        Tokenizer tokenizer = new Tokenizer();
        tokenizer.setString(",,,one,,'2, two',  three ,four,,, ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            System.out.println("token = " + token);
        }
    }
}

