/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.diff.EncodingDetectorNoOp;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class EncodingDetector {
    public abstract boolean isDone();

    public abstract void handleData(byte[] var1, int var2, int var3);

    public abstract void dataEnd();

    public abstract String getDetectedCharset();

    public abstract void reset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectEncoding(String fileName, String defaultEncoding, Boolean autoDetectEncoding) {
        String encoding = StringUtils.fixEmpty(defaultEncoding);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            if (autoDetectEncoding != null && autoDetectEncoding.booleanValue()) {
                int nread;
                boolean first = true;
                EncodingDetectorNoOp detector = new EncodingDetectorNoOp();
                byte[] buf = new byte[4096];
                while ((nread = fis.read(buf)) > 0) {
                    if (first) {
                        if (buf[0] == 60 && buf[1] == 63 && (encoding = EncodingDetector.findXMLEncoding(buf)) != null) {
                            String string = encoding;
                            return string;
                        }
                        first = false;
                    }
                    ((EncodingDetector)detector).handleData(buf, 0, nread);
                    if (!((EncodingDetector)detector).isDone()) continue;
                }
                ((EncodingDetector)detector).dataEnd();
                String detectedCharset = ((EncodingDetector)detector).getDetectedCharset();
                if (detectedCharset != null) {
                    encoding = detectedCharset;
                }
                ((EncodingDetector)detector).reset();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return encoding;
    }

    private static String findXMLEncoding(byte[] buf) {
        int endIndex = EncodingDetector.indexOf(buf, new byte[]{63, 62}, 0);
        if (endIndex != -1) {
            try {
                String encoding;
                String ascii = new String(buf, 0, endIndex, "ascii");
                if (ascii.contains("encoding=") && (encoding = StringUtils.midStr(ascii, "encoding=\"", "\"")) != null) {
                    return encoding;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int indexOf(byte[] str1, byte[] sequence, int start_index) {
        for (int i = start_index; i < str1.length; ++i) {
            byte b = str1[i];
            if (!EncodingDetector.isSequenceMatch(str1, i, sequence)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isSequenceMatch(byte[] str1, int index, byte[] sequence) {
        for (int i = index; i < str1.length && i < index + sequence.length; ++i) {
            byte byteVal = str1[i];
            if (byteVal == -1) {
                return false;
            }
            if (byteVal == sequence[i - index]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String s = EncodingDetector.detectEncoding("F:\\Volante\\Cartridges\\ExternalMessages\\XML\\XSD\\Encoding\\samples\\purchaseOrderutf16.xml", null, Boolean.TRUE);
        System.out.println(s);
    }
}

