/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.util.diff.DiffResultSpan;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LineReport {
    Map lineReport1 = new HashMap();
    Map lineReport2 = new HashMap();
    int maxLine1;
    int maxLine2;
    List diffReport;

    public LineReport() {
    }

    public LineReport(List report) {
        this.diffReport = report;
        this.init(report);
    }

    public List getDiffReport() {
        return this.diffReport;
    }

    void init(List report) {
        this.lineReport1.clear();
        this.lineReport2.clear();
        for (Object aReport : report) {
            int j;
            DiffResultSpan span = (DiffResultSpan)aReport;
            int sourceIndex = span.getSourceIndex();
            int length = span.getLength();
            int destIndex = span.getDestIndex();
            if (sourceIndex != -1) {
                j = sourceIndex;
                while (j < sourceIndex + length) {
                    this.lineReport1.put(Wrapper.box(j), span);
                    this.maxLine1 = j++;
                }
            }
            if (destIndex == -1) continue;
            j = destIndex;
            while (j < destIndex + length) {
                this.lineReport2.put(Wrapper.box(j), span);
                this.maxLine2 = j++;
            }
        }
    }

    public int getMaxLine(boolean source) {
        return source ? this.maxLine1 : this.maxLine2;
    }

    public DiffResultSpan getResult(int line, boolean source) {
        Map report = source ? this.lineReport1 : this.lineReport2;
        DiffResultSpan lineSpan = (DiffResultSpan)report.get(Wrapper.box(line));
        return lineSpan;
    }

    public int mapLine(int line, boolean source) {
        DiffResultSpan diffResultSpan = (DiffResultSpan)(source ? this.lineReport1.get(Wrapper.box(line)) : this.lineReport2.get(Wrapper.box(line)));
        if (diffResultSpan != null) {
            int otherLine;
            int lineInc = line - (source ? diffResultSpan.getSourceIndex() : diffResultSpan.getDestIndex());
            int n = otherLine = source ? diffResultSpan.getDestIndex() : diffResultSpan.getSourceIndex();
            if (otherLine != -1) {
                return otherLine + lineInc;
            }
        }
        return -1;
    }

    public int getNextChange(int line, boolean source) {
        Map report = source ? this.lineReport1 : this.lineReport2;
        int start = line + 1;
        DiffResultSpan currentResultSpan = (DiffResultSpan)report.get(Wrapper.box(line));
        if (currentResultSpan != null) {
            start = (source ? currentResultSpan.getSourceIndex() : currentResultSpan.getDestIndex()) + currentResultSpan.getLength();
        }
        for (int i = start; i < report.size(); ++i) {
            DiffResultSpan diffResultSpan = (DiffResultSpan)report.get(Wrapper.box(i));
            if (diffResultSpan == null || diffResultSpan.getStatus() == 0) continue;
            return source ? diffResultSpan.getSourceIndex() : diffResultSpan.getDestIndex();
        }
        return -1;
    }

    public int getPreviousChange(int line, boolean source) {
        Map report = source ? this.lineReport1 : this.lineReport2;
        int start = line - 1;
        DiffResultSpan currentResultSpan = (DiffResultSpan)report.get(Wrapper.box(line));
        if (currentResultSpan != null) {
            start = (source ? currentResultSpan.getSourceIndex() : currentResultSpan.getDestIndex()) - 1;
        }
        for (int i = start; i >= 0; --i) {
            DiffResultSpan diffResultSpan = (DiffResultSpan)report.get(Wrapper.box(i));
            if (diffResultSpan == null || diffResultSpan.getStatus() == 0) continue;
            return source ? diffResultSpan.getSourceIndex() : diffResultSpan.getDestIndex();
        }
        return -1;
    }
}

