/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.io;

import com.tplus.transform.util.io.FileInfo;
import com.tplus.transform.util.io.FileSystemInternal;

public abstract class AbstractFileInfo
implements FileInfo {
    private String name;
    private String qName;
    private FileSystemInternal fileSystem;

    public AbstractFileInfo(String qName, String name, FileSystemInternal fileSystem) {
        this.qName = qName;
        this.name = name;
        this.fileSystem = fileSystem;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qName;
    }

    @Override
    public FileInfo getParent() {
        return this.fileSystem.getParent(this);
    }

    @Override
    public boolean isDirectory() {
        return this.fileSystem.isDirectory(this);
    }

    @Override
    public FileInfo[] listFiles() {
        return this.fileSystem.listFiles(this);
    }

    @Override
    public boolean createDirectory() {
        return this.fileSystem.createDirectory(this);
    }

    @Override
    public boolean deleteDirectory() {
        return this.fileSystem.deleteDirectory(this);
    }

    @Override
    public boolean delete() {
        return this.fileSystem.delete(this);
    }

    @Override
    public boolean exists() {
        return this.fileSystem.exists(this);
    }

    @Override
    public int compareTo(Object o) {
        FileInfo fileInfo = (FileInfo)o;
        return this.qName.compareTo(fileInfo.getQualifiedName());
    }

    @Override
    public String toString() {
        return this.qName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractFileInfo) {
            AbstractFileInfo fileInfo = (AbstractFileInfo)obj;
            return this.qName.equals(fileInfo.qName);
        }
        return false;
    }

    public int hashCode() {
        return this.qName.hashCode();
    }
}

