/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.io;

import com.tplus.transform.util.io.FileInfo;
import com.tplus.transform.util.io.FileSystemInternal;
import com.tplus.transform.util.io.PlatformFileInfo;
import java.io.File;

public class PlatformFileSystem
implements FileSystemInternal {
    static PlatformFileSystem platformFileSystem;

    protected PlatformFileSystem() {
    }

    @Override
    public FileInfo getParent(FileInfo info) {
        return new PlatformFileInfo(this.getPlatformFile(info).getParentFile(), this);
    }

    @Override
    public boolean isDirectory(FileInfo info) {
        return this.getPlatformFile(info).isDirectory();
    }

    @Override
    public FileInfo[] listFiles(FileInfo info) {
        File[] files = this.getPlatformFile(info).listFiles();
        return this.createArray(files);
    }

    FileInfo[] createArray(File[] files) {
        FileInfo[] fileInfos = new FileInfo[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileInfos[i] = new PlatformFileInfo(files[i], this);
        }
        return fileInfos;
    }

    @Override
    public boolean createDirectory(FileInfo info) {
        return this.getPlatformFile(info).mkdirs();
    }

    @Override
    public boolean deleteDirectory(FileInfo info) {
        return this.getPlatformFile(info).delete();
    }

    @Override
    public boolean delete(FileInfo info) {
        return new File(info.getQualifiedName()).delete();
    }

    @Override
    public boolean exists(FileInfo info) {
        return this.getPlatformFile(info).exists();
    }

    @Override
    public FileInfo[] getRoots() {
        return this.createArray(File.listRoots());
    }

    @Override
    public FileInfo createFileInfo(String parent, String child) {
        return new PlatformFileInfo(new File(parent, child), this);
    }

    @Override
    public FileInfo createFileInfo(FileInfo parent, String child) {
        return new PlatformFileInfo(new File(this.getPlatformFile(parent), child), this);
    }

    @Override
    public FileInfo createFileInfo(String path) {
        return new PlatformFileInfo(new File(path), this);
    }

    protected File getPlatformFile(FileInfo fileInfo) {
        return new File(fileInfo.getQualifiedName());
    }

    @Override
    public String getQualfiedName(String qName) {
        return qName;
    }

    public static PlatformFileSystem getPlatformFileSystem() {
        return platformFileSystem;
    }
}

