/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.io;

import com.tplus.transform.util.io.FileInfo;
import com.tplus.transform.util.io.PlatformFileInfo;
import com.tplus.transform.util.io.PlatformFileSystem;
import java.io.File;
import java.io.IOException;

public class RootDirFileSystem
extends PlatformFileSystem {
    FileInfo rootDir;

    public RootDirFileSystem(String rootDir) throws IOException {
        File rootFile = new File(rootDir).getCanonicalFile();
        this.rootDir = new PlatformFileInfo(rootFile, this);
    }

    @Override
    public FileInfo[] getRoots() {
        return new FileInfo[]{this.rootDir};
    }

    @Override
    public FileInfo getParent(FileInfo info) {
        try {
            File file = this.getPlatformFile(info).getParentFile();
            String canPath = file.getCanonicalPath();
            if (canPath.equals(this.rootDir.getQualifiedName())) {
                return null;
            }
            if (!canPath.contains(this.rootDir.getQualifiedName())) {
                return null;
            }
            return new PlatformFileInfo(file, this);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getQualfiedName(String qName) {
        if (qName.indexOf(this.rootDir.getQualifiedName()) != 0) {
            try {
                qName = new File(qName).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return qName.substring(this.rootDir.getQualifiedName().length());
    }
}

