/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.Log;
import java.text.MessageFormat;

public abstract class AbstractLogger
implements Log {
    @Override
    public void info(String fqcn, Object message, Throwable throwable) {
        this.info(message, null);
    }

    @Override
    public void info(Object object) {
        this.info(object, null);
    }

    @Override
    public void infoFormatted(String format, Object[] values) {
        if (this.isInfoEnabled()) {
            this.info(MessageFormat.format(format, values));
        }
    }

    @Override
    public void log(Object object, Log.LogLevel level, Throwable throwable) {
        if (level == FATAL) {
            this.fatal(object, throwable);
        }
        if (level == DEBUG) {
            this.debug(object, throwable);
        }
        if (level == INFO) {
            this.info(object, throwable);
        }
        if (level == ERROR) {
            this.error(object, throwable);
        }
        if (level == WARN) {
            this.warn(object, throwable);
        }
        if (level == TRACE) {
            this.trace(object, throwable);
        }
    }

    @Override
    public void fatal(String fqcn, Object message, Throwable throwable) {
        this.fatal(message, null);
    }

    @Override
    public void fatal(Object object) {
        this.fatal(object, null);
    }

    @Override
    public void fatalFormatted(String format, Object[] values) {
        if (this.isFatalEnabled()) {
            this.fatal(MessageFormat.format(format, values));
        }
    }

    @Override
    public void error(String fqcn, Object message, Throwable throwable) {
        this.error(message, null);
    }

    @Override
    public void error(Object object) {
        this.error(object, null);
    }

    @Override
    public void errorFormatted(String format, Object[] values) {
        if (this.isErrorEnabled()) {
            this.error(MessageFormat.format(format, values));
        }
    }

    @Override
    public void debug(String fqcn, Object message, Throwable throwable) {
        this.debug(message, null);
    }

    @Override
    public void debug(Object object) {
        this.debug(object, null);
    }

    @Override
    public void debugFormatted(String format, Object[] values) {
        if (this.isDebugEnabled()) {
            this.debug(MessageFormat.format(format, values));
        }
    }

    @Override
    public void warn(String fqcn, Object message, Throwable throwable) {
        this.warn(message, null);
    }

    @Override
    public void warn(Object object) {
        this.warn(object, null);
    }

    @Override
    public void warnFormatted(String format, Object[] values) {
        if (this.isWarnEnabled()) {
            this.warn(MessageFormat.format(format, values));
        }
    }

    @Override
    public void trace(String fqcn, Object message, Throwable throwable) {
        this.trace(message, null);
    }

    @Override
    public void trace(Object object) {
        this.trace(object, null);
    }

    @Override
    public void traceFormatted(String format, Object[] values) {
        if (this.isTraceEnabled()) {
            this.trace(MessageFormat.format(format, values));
        }
    }

    @Override
    public void unexpectedError(Throwable throwable) {
        this.error("Unexpected runtime error", throwable);
    }

    @Override
    public void remotingError(Throwable throwable) {
        this.error("Unexpected remote error", throwable);
    }

    public static Object sanitizeMessage(Object message) {
        if (message != null) {
            AbstractLogger.sanitizeMessage(message.toString());
        }
        return message;
    }

    public static String sanitizeMessage(String message) {
        String clean = message.replace('\n', '_').replace('\r', '_');
        return clean;
    }
}

