/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.JDKLogger;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class JDKLogFactory
extends LogFactory {
    static void loadProps() {
        InputStream inputStream = JDKLogFactory.class.getResourceAsStream("/logging.properties");
        try {
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
            }
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().severe("Could not load default logging.properties file");
            Logger.getAnonymousLogger().severe(e.getMessage());
        }
    }

    @Override
    public Log getInstance(String name) {
        return new JDKLogger(name);
    }

    static {
        JDKLogFactory.loadProps();
    }
}

