/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.Log4JFactory;
import java.lang.reflect.Method;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JLogger
extends AbstractLogger {
    final transient Logger logger;
    private static Level TRACE_LEVEL = Level.DEBUG;
    private static final String FQCN = Log4JLogger.class.getName();

    public Log4JLogger(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    private Logger getLogger() {
        return this.logger;
    }

    @Override
    public void error(Object message, Throwable throwable) {
        this.logImpl(FQCN, Level.ERROR, message, throwable);
    }

    @Override
    public void error(String fqcn, Object message, Throwable throwable) {
        this.logImpl(fqcn, Level.ERROR, message, throwable);
    }

    @Override
    public void debug(Object message, Throwable throwable) {
        this.logImpl(FQCN, Level.DEBUG, message, throwable);
    }

    @Override
    public void debug(String fqcn, Object message, Throwable throwable) {
        this.logImpl(fqcn, Level.DEBUG, message, throwable);
    }

    @Override
    public void fatal(Object message, Throwable throwable) {
        this.fatal(FQCN, message, throwable);
    }

    @Override
    public void fatal(String fqcn, Object message, Throwable throwable) {
        this.logImpl(fqcn, Level.FATAL, message, throwable);
    }

    @Override
    public void info(Object message, Throwable throwable) {
        this.logImpl(FQCN, Level.INFO, message, throwable);
    }

    @Override
    public void info(String fqcn, Object message, Throwable throwable) {
        this.logImpl(fqcn, Level.INFO, message, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled() && Log4JFactory.isConfigured();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled() && Log4JFactory.isConfigured();
    }

    @Override
    public void warn(Object message, Throwable throwable) {
        this.logImpl(FQCN, Level.WARN, message, throwable);
    }

    @Override
    public void warn(String fqcn, Object message, Throwable throwable) {
        this.logImpl(fqcn, Level.WARN, message, throwable);
    }

    @Override
    public void trace(Object message, Throwable throwable) {
        this.logImpl(FQCN, TRACE_LEVEL, message, throwable);
    }

    @Override
    public void trace(String fqcn, Object message, Throwable throwable) {
        this.logImpl(fqcn, TRACE_LEVEL, message, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.getLogger().isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isEnabledFor((Priority)TRACE_LEVEL);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void info(Object object) {
        this.info(object, null);
    }

    @Override
    public void fatal(Object object) {
        this.fatal(object, null);
    }

    @Override
    public void error(Object object) {
        this.error(object, null);
    }

    @Override
    public void debug(Object object) {
        this.debug(object, null);
    }

    @Override
    public void warn(Object object) {
        this.warn(object, null);
    }

    @Override
    public void trace(Object object) {
        this.trace(object, null);
    }

    @Override
    public void unexpectedError(Throwable throwable) {
        this.error("Unexpected runtime error", throwable);
    }

    @Override
    public void remotingError(Throwable throwable) {
        this.error("Unexpected remote error", throwable);
    }

    private void logImpl(String fqcn, Level level, Object message, Throwable throwable) {
        this.getLogger().log(fqcn, (Priority)level, Log4JLogger.sanitizeMessage(message), throwable);
    }

    @Override
    public void setLevel(Log.LogLevel level) {
        Level cmpLevel = Level.ALL;
        if (level == DEBUG) {
            cmpLevel = Level.DEBUG;
        }
        if (level == INFO) {
            cmpLevel = Level.INFO;
        }
        if (level == ERROR) {
            cmpLevel = Level.ERROR;
        }
        if (level == FATAL) {
            cmpLevel = Level.FATAL;
        }
        if (level == WARN) {
            cmpLevel = Level.WARN;
        }
        if (level == TRACE) {
            cmpLevel = TRACE_LEVEL;
        }
        this.getLogger().setLevel(cmpLevel);
    }

    static void initTraceLevel() {
        try {
            Method isTraceEnabled = Logger.class.getMethod("isTraceEnabled", new Class[0]);
            Log4JLogger.setTraceLevel();
        }
        catch (Throwable e) {
            TRACE_LEVEL = Level.DEBUG;
        }
    }

    private static void setTraceLevel() {
        TRACE_LEVEL = Level.TRACE;
    }

    static {
        Log4JLogger.initTraceLevel();
    }
}

