/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.SimpleLogFactory;
import java.lang.reflect.Method;

public abstract class LogFactory {
    private static LogFactory cachedFactory;
    private static final String FACTORY_PROPERTY = "volante.log.class";

    public static Log getLog(String name) {
        return LogFactory.getFactory().getInstance(name);
    }

    public static Log getLog(Class reference, String name) {
        return LogFactory.getFactory().getInstance(reference, name);
    }

    public static Log getLog(Class cls) {
        return LogFactory.getFactory().getInstance(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogFactory getFactory() {
        if (cachedFactory != null) return cachedFactory;
        Class<LogFactory> clazz = LogFactory.class;
        synchronized (LogFactory.class) {
            String factoryClassStr = System.getProperty(FACTORY_PROPERTY);
            if (factoryClassStr == null) {
                factoryClassStr = LogFactory.isSLF4JAvailable() ? "com.tplus.transform.util.log.SLF4JLogFactory" : (LogFactory.isLog4JAvailable() ? "com.tplus.transform.util.log.Log4JFactory" : (LogFactory.isJdk14Available() ? "com.tplus.transform.util.log.JDKLogFactory" : (LogFactory.isOSGiAvailable() ? "com.tplus.transform.util.log.osgi.OSGILogFactory" : "com.tplus.transform.util.log.SimpleLogFactory")));
            }
            try {
                Class<?> factoryClass = Class.forName(factoryClassStr);
                cachedFactory = (LogFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                cachedFactory = new SimpleLogFactory();
                Log logInstance = cachedFactory.getInstance("logger");
                logInstance.error("Error instantiating logger class " + factoryClassStr, e);
            }
            return cachedFactory;
        }
    }

    protected static boolean isOSGiAvailable() {
        try {
            LogFactory.loadClass("org.osgi.service.log.LogService");
            Class cls = LogFactory.loadClass("org.osgi.framework.FrameworkUtil");
            Method getBundleMethod = cls.getMethod("getBundle", Class.class);
            Object bundler = getBundleMethod.invoke(null, LogFactory.class);
            return bundler != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static boolean isLog4JAvailable() {
        try {
            LogFactory.loadClass("org.apache.log4j.Logger");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static boolean isSLF4JAvailable() {
        try {
            LogFactory.loadClass("org.slf4j.Logger");
            LogFactory.loadClass("org.slf4j.spi.LocationAwareLogger");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static boolean isJdk14Available() {
        try {
            LogFactory.loadClass("java.util.logging.Logger");
            Class throwable = LogFactory.loadClass("java.lang.Throwable");
            return throwable.getDeclaredMethod("getStackTrace", new Class[0]) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public abstract Log getInstance(String var1);

    public Log getInstance(Class cls) {
        return this.getInstance(cls.getName());
    }

    public Log getInstance(Class cls, String name) {
        return this.getInstance(name);
    }
}

