/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;

public class SimpleLog
extends AbstractLogger {
    private String name;
    private static final String ERROR = "ERROR";
    private static final Object DEBUG = "DEBUG";
    private static final Object INFO = "INFO";
    private static final Object WARN = "WARN";
    private static final Object FATAL = "FATAL";

    public SimpleLog(String name) {
        this.name = name;
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void trace(Object object, Throwable throwable) {
    }

    @Override
    public void debug(Object object, Throwable throwable) {
    }

    @Override
    public void info(Object object, Throwable throwable) {
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.log(WARN, object, throwable);
    }

    @Override
    public void error(Object object, Throwable throwable) {
        this.log((Object)ERROR, object, throwable);
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.log(FATAL, object, throwable);
    }

    @Override
    public void setLevel(Log.LogLevel level) {
    }

    private void log(Object severity, Object object, Throwable throwable) {
        System.out.println("[" + severity + "]" + object);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

