/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log.osgi;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.log.osgi.OSGIServiceLogger;
import com.tplus.transform.util.log.osgi.OSGiLogger;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;

public class OSGILogFactory
extends LogFactory {
    Map bundleServiceLoggerMap = new Hashtable();
    OSGIServiceLogger defaultServiceLogger;
    boolean initialized;

    public synchronized void initialize() {
        if (!this.initialized) {
            this.start();
            this.defaultServiceLogger = this.getOSGIServiceLogger(OSGILogFactory.class);
            this.initialized = true;
        }
    }

    @Override
    public synchronized Log getInstance(String name) {
        this.initialize();
        return new OSGiLogger(name, this.defaultServiceLogger);
    }

    @Override
    public synchronized Log getInstance(Class cls, String name) {
        this.initialize();
        OSGIServiceLogger serviceLogger = this.getOSGIServiceLogger(cls);
        return new OSGiLogger(name, serviceLogger);
    }

    @Override
    public synchronized Log getInstance(Class cls) {
        this.initialize();
        OSGIServiceLogger serviceLogger = this.getOSGIServiceLogger(cls);
        return new OSGiLogger(cls.getName(), serviceLogger);
    }

    public static boolean isOSGI() {
        Bundle bundle = FrameworkUtil.getBundle(OSGILogFactory.class);
        return bundle != null;
    }

    private OSGIServiceLogger getOSGIServiceLogger(Class cls) {
        OSGIServiceLogger serviceLogger = this.defaultServiceLogger;
        Bundle bundle = FrameworkUtil.getBundle((Class)cls);
        if (bundle != null) {
            serviceLogger = this.getOSGIServiceLogger(bundle);
        }
        return serviceLogger;
    }

    private OSGIServiceLogger getOSGIServiceLogger(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        OSGIServiceLogger osgiServiceLogger = (OSGIServiceLogger)this.bundleServiceLoggerMap.get(bundleId);
        if (osgiServiceLogger == null) {
            osgiServiceLogger = this.createOSGOServiceLogger(bundle);
            this.bundleServiceLoggerMap.put(Wrapper.box(bundleId), osgiServiceLogger);
        }
        return osgiServiceLogger;
    }

    private OSGIServiceLogger createOSGOServiceLogger(Bundle bundle) {
        OSGIServiceLogger osgiServiceLogger = new OSGIServiceLogger();
        osgiServiceLogger.initOSGI(bundle);
        return osgiServiceLogger;
    }

    private void bundleUnloaded(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        this.bundleServiceLoggerMap.remove(Wrapper.box(bundleId));
    }

    synchronized void start() {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(OSGILogFactory.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            bundleContext.addBundleListener(new BundleListener(){

                public void bundleChanged(BundleEvent bundleEvent) {
                    if (bundleEvent.getType() == 2) {
                        // empty if block
                    }
                    if (bundleEvent.getType() == 16) {
                        OSGILogFactory.this.bundleUnloaded(bundleEvent.getBundle());
                    }
                }
            });
        }
    }
}

