/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log.osgi;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.osgi.OSGIServiceLogger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class OSGiLogger
extends AbstractLogger {
    public static final boolean DEBUG_ENABLED = false;
    private String name;
    private final OSGIServiceLogger osgiServiceLogger;
    private static final long serialVersionUID = 1L;

    public OSGiLogger(String name, OSGIServiceLogger osgiServiceLogger) {
        this.name = name;
        this.osgiServiceLogger = osgiServiceLogger;
    }

    private final void logImpl(int level, Object message, Throwable t) {
        message = OSGiLogger.sanitizeMessage(message);
        LogService logservice = this.osgiServiceLogger.getLogService();
        ServiceReference serviceref = this.osgiServiceLogger.getServiceReference();
        if (logservice != null) {
            try {
                if (t != null) {
                    logservice.log(serviceref, level, message.toString(), t);
                } else {
                    logservice.log(serviceref, level, message.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public void trace(Object msg, Throwable t) {
        this.logImpl(4, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(Object msg) {
        this.logImpl(4, msg, null);
    }

    @Override
    public void debug(Object msg, Throwable t) {
        this.logImpl(4, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(Object msg, Throwable throwable) {
        this.logImpl(3, msg, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(Object msg, Throwable throwable) {
        this.logImpl(2, msg, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(Object msg, Throwable throwable) {
        this.logImpl(1, msg, throwable);
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public void fatal(Object msg, Throwable throwable) {
        this.logImpl(1, msg, throwable);
    }

    @Override
    public void setLevel(Log.LogLevel level) {
    }
}

