/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.net;

import com.tplus.transform.io.Base64Binary;
import com.tplus.transform.util.Configuration;
import com.tplus.transform.util.ConfigurationManager;
import com.tplus.transform.util.ConfigurationUtil;
import com.tplus.transform.util.IConfiguration;
import com.tplus.transform.util.ISection;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ProxySettings
implements Configuration,
Cloneable {
    public static final String PROXY_SETTINGS = "Proxy Settings";
    public static final String PROXY_SECTION = "proxy";
    public static final String AUTO_DETECT_PROXY_SETTINGS = "autoDetectProxySettings";
    public static final String USE_PROXY_SETTINGS = "useProxySettings";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String PROXY_USER = "proxyUser";
    public static final String PROXY_PASS = "proxyPassword";
    public static final String PROXY_PASS_ENCRYPTED = "proxyPasswordEncrypted";
    private static final String USE_PAC = "usePAC";
    private static final String PAC_URL = "pacURL";
    private static final String PAC_USER = "pacProxyUser";
    private static final String PAC_PASS = "pacProxyPassword";
    private static final String PAC_PASS_ENCRYPTED = "pacProxyPasswordEncrypted";
    private static final String NO_PROXY_LIST = "noProxyList";
    private static final String PAC_HOST = "pacHost";
    private static final String PAC_PORT = "pacPort";
    private static final String TEST_SITE = "testSite";
    public String LAST_ERROR;
    static volatile boolean loaded;
    boolean autoDetectProxySettings;
    boolean usePAC;
    String pacURL;
    List authenticationSettings = new ArrayList();
    boolean useProxySettings;
    String ignoreProxyList;
    String host;
    String port;
    String proxyUser;
    String proxyPassword;
    String testSite;

    public boolean isAutoDetectProxySettings() {
        return this.autoDetectProxySettings;
    }

    public void setAutoDetectProxySettings(boolean autoDetectProxySettings) {
        this.autoDetectProxySettings = autoDetectProxySettings;
    }

    public boolean isUseProxySettings() {
        return this.useProxySettings;
    }

    public void setUseProxySettings(boolean useProxySettings) {
        this.useProxySettings = useProxySettings;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getIgnoreProxyList() {
        return this.ignoreProxyList;
    }

    public void setIgnoreProxyList(String ignoreProxyList) {
        this.ignoreProxyList = ignoreProxyList;
    }

    public boolean isUsePAC() {
        return this.usePAC;
    }

    public void setUsePAC(boolean usePAC) {
        this.usePAC = usePAC;
    }

    public String getPacURL() {
        return this.pacURL;
    }

    public void setPacURL(String pacURL) {
        this.pacURL = pacURL;
    }

    public String getTestSite() {
        return this.testSite;
    }

    public void setTestSite(String testSite) {
        this.testSite = testSite;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static final ProxySettings loadProxySettings() {
        ProxySettings proxySettings = (ProxySettings)ConfigurationManager.getInstance().getConfig(PROXY_SETTINGS);
        if (!loaded) {
            IConfiguration userConfig = ConfigurationUtil.getUserConfig();
            proxySettings.load(userConfig);
            loaded = true;
        }
        return proxySettings;
    }

    @Override
    public String getName() {
        return PROXY_SETTINGS;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void load(IConfiguration config) {
        String host;
        ISection proxySec = config.getSection(PROXY_SECTION);
        this.autoDetectProxySettings = proxySec.getKeyBoolValue(AUTO_DETECT_PROXY_SETTINGS, false);
        this.usePAC = proxySec.getKeyBoolValue(USE_PAC, false);
        this.pacURL = proxySec.getKeyValue(PAC_URL, null);
        this.authenticationSettings.clear();
        for (int i = 0; i < 100 && (host = proxySec.getKeyValue(PAC_HOST + i, null)) != null; ++i) {
            int port = proxySec.getKeyIntValue(PAC_PORT + i, 0);
            String user = proxySec.getKeyValue(PAC_USER + i, null);
            String pass = proxySec.getKeyValue(PAC_PASS + i, null);
            if (pass == null) {
                pass = this.decrypt(proxySec.getKeyValue(PAC_PASS_ENCRYPTED + i, null));
            }
            this.authenticationSettings.add(new AuthenticationSetting(host, port, user, pass));
        }
        this.useProxySettings = proxySec.getKeyBoolValue(USE_PROXY_SETTINGS, false);
        this.host = proxySec.getKeyValue(HOST, null);
        this.port = proxySec.getKeyValue(PORT, null);
        this.proxyUser = proxySec.getKeyValue(PROXY_USER, null);
        this.proxyPassword = proxySec.getKeyValue(PROXY_PASS, null);
        if (this.proxyPassword == null) {
            this.proxyPassword = this.decrypt(proxySec.getKeyValue(PROXY_PASS_ENCRYPTED, null));
        }
        this.ignoreProxyList = proxySec.getKeyValue(NO_PROXY_LIST, null);
        this.testSite = proxySec.getKeyValue(TEST_SITE, null);
    }

    @Override
    public void save(IConfiguration config) {
        ISection proxy = config.getSection(PROXY_SECTION);
        proxy.removeAllKeys();
        proxy.addKeyBoolValue(AUTO_DETECT_PROXY_SETTINGS, this.autoDetectProxySettings);
        proxy.addKeyBoolValue(USE_PAC, this.usePAC);
        proxy.addKeyValue(PAC_URL, this.pacURL);
        int index = 0;
        for (Object authenticationSetting : this.authenticationSettings) {
            AuthenticationSetting settings = (AuthenticationSetting)authenticationSetting;
            if (!settings.isSavePassword()) continue;
            proxy.addKeyValue(PAC_HOST + index, settings.getHost());
            proxy.addKeyIntValue(PAC_PORT + index, settings.getRequestingPort());
            proxy.addKeyValue(PAC_USER + index, settings.getUserName());
            proxy.addKeyValue(PAC_PASS_ENCRYPTED + index, this.encrypt(settings.getPassword()));
            ++index;
        }
        proxy.addKeyBoolValue(USE_PROXY_SETTINGS, this.useProxySettings);
        proxy.addKeyValue(HOST, this.host);
        proxy.addKeyValue(PORT, this.port);
        proxy.addKeyValue(PROXY_USER, this.proxyUser);
        proxy.addKeyValue(PROXY_PASS_ENCRYPTED, this.encrypt(this.proxyPassword));
        proxy.addKeyValue(NO_PROXY_LIST, this.ignoreProxyList);
        proxy.addKeyValue(TEST_SITE, this.testSite);
    }

    public List getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    public AuthenticationSetting getAuthenticationSettings(String host, int requestingPort) {
        for (Object authenticationSetting : this.authenticationSettings) {
            AuthenticationSetting settings = (AuthenticationSetting)authenticationSetting;
            if (!settings.getHost().equals(host) || settings.getRequestingPort() != requestingPort) continue;
            return settings;
        }
        return null;
    }

    public void addAuthenticationSettings(AuthenticationSetting authenticationSetting) {
        this.authenticationSettings.add(authenticationSetting.clone());
    }

    public void addAuthenticationSettings(String host, int requestingPort, String user, String pass) {
        AuthenticationSetting authenticationSetting = new AuthenticationSetting(host, requestingPort, user, pass);
        this.authenticationSettings.add(authenticationSetting);
    }

    private String encrypt(String value) {
        try {
            if (value != null) {
                value = Base64Binary.fromBinary(value.getBytes("utf-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    private String decrypt(String value) {
        try {
            if (value != null) {
                value = new String(Base64Binary.toBinary(value), "utf-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public void clearPACProxies() {
        this.authenticationSettings.clear();
    }

    public static class AuthenticationSetting
    implements Cloneable {
        String host;
        int requestingPort;
        String userName;
        String password;
        boolean savePassword;

        public AuthenticationSetting(String host, int requestingPort, String userName, String password) {
            this.host = host;
            this.requestingPort = requestingPort;
            this.userName = userName;
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public int getRequestingPort() {
            return this.requestingPort;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isSavePassword() {
            return this.savePassword;
        }

        public void setSavePassword(boolean savePassword) {
            this.savePassword = savePassword;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

