/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.performance;

import com.tplus.transform.util.performance.MessageLatency;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class MessageLatencyWriter {
    String fileName;
    private DataOutputStream writer;
    private static final int VERSION = 1;
    static Random rand = new Random();

    public MessageLatencyWriter(String fileName) throws IOException {
        this.fileName = fileName;
        this.writer = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        this.writer.writeInt(1);
    }

    public synchronized void writeLatency(MessageLatency messageLatency) throws IOException {
        if (this.writer != null) {
            int slots = messageLatency.getSlots();
            for (int i = 0; i < slots; ++i) {
                this.writer.writeLong(messageLatency.getTime(i));
            }
        }
    }

    public void writeSlotInfo(String[] strings) throws IOException {
        this.writer.writeInt(strings.length);
        for (String string : strings) {
            this.writer.writeUTF(string);
        }
    }

    public synchronized void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }

    public static void cmtmain(String[] args) throws IOException {
        MessageLatencyWriter messageLatencyWriter = new MessageLatencyWriter("latency.out");
        MessageLatency messageLatency = MessageLatencyWriter.prepareLatencyData();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            messageLatency = MessageLatencyWriter.prepareLatencyData();
            messageLatencyWriter.writeLatency(messageLatency);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time taken =" + (end - start));
        messageLatencyWriter.close();
    }

    private static MessageLatency prepareLatencyData() {
        MessageLatency messageLatency = new MessageLatency(5);
        long now = System.currentTimeMillis();
        messageLatency.setTime(now, 0);
        messageLatency.setTime(now + 1L, 1);
        messageLatency.setTime(now + 2L, 2);
        messageLatency.setTime(now + 3L, 3);
        messageLatency.setTime(now + (long)rand.nextInt(5), 4);
        return messageLatency;
    }
}

