/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.regex;

import com.tplus.transform.util.regex.RegExp;
import com.tplus.transform.util.regex.RegexTranslator;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JDKRegExp
implements RegExp {
    private String patternStr;
    Object pattern;
    static Map patternMap = new Hashtable();

    public JDKRegExp(String patternStr) {
        this.patternStr = patternStr;
        this.compile(patternStr);
    }

    private void compile(String patternStr) {
        try {
            WeakReference weakref = (WeakReference)patternMap.get(patternStr);
            if (weakref != null) {
                this.pattern = weakref.get();
            }
            if (this.pattern == null) {
                patternStr = this.translatePattern(patternStr);
                this.pattern = Pattern.compile(patternStr);
                patternMap.put(patternStr, new WeakReference<Object>(this.pattern));
            }
        }
        catch (Exception e) {
            runtimeLog.error("Illegal Regex " + patternStr, e);
        }
    }

    private String translatePattern(String patternStr) {
        try {
            return RegexTranslator.translate(patternStr, false);
        }
        catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
            return patternStr;
        }
    }

    @Override
    public boolean matches(String value) {
        if (this.pattern != null) {
            Matcher macher = ((Pattern)this.pattern).matcher(value);
            return macher.matches();
        }
        return true;
    }
}

