/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.xml;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMUtil {
    public static String convertElementToXML(Node node) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(buffer));
            return buffer.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String convertDocToXml(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    public static Node importNode(Node parent, Node child) {
        Node copy = null;
        Document doc = parent.getOwnerDocument();
        switch (child.getNodeType()) {
            case 4: {
                copy = doc.createCDATASection(((CDATASection)child).getData());
                break;
            }
            case 8: {
                copy = doc.createComment(((Comment)child).getData());
                break;
            }
            case 11: {
                copy = doc.createDocumentFragment();
                break;
            }
            case 1: {
                Element elem = doc.createElement(((Element)child).getTagName());
                copy = elem;
                NamedNodeMap attributes = child.getAttributes();
                if (attributes == null) break;
                int size = attributes.getLength();
                for (int i = 0; i < size; ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    elem.setAttribute(attr.getName(), attr.getValue());
                }
                break;
            }
            case 5: {
                copy = doc.createEntityReference(child.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)child;
                copy = doc.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 3: {
                copy = doc.createTextNode(((Text)child).getData());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid node type: " + child.getNodeType());
            }
        }
        try {
            NodeList children = child.getChildNodes();
            if (children != null) {
                int size = children.getLength();
                for (int i = 0; i < size; ++i) {
                    Node newChild = children.item(i);
                    if (newChild == null) continue;
                    DOMUtil.importNode(copy, newChild);
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        parent.appendChild(copy);
        return copy;
    }
}

