/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.xml;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.CharacterEscapeHandler;
import com.tplus.transform.util.xml.DumbEscapeHandler;
import com.tplus.transform.util.xml.NamespaceContext;
import com.tplus.transform.util.xml.NamespaceContextImpl;
import com.tplus.transform.util.xml.QName;
import com.tplus.transform.util.xml.XMLWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XMLWriterImpl
implements XMLWriter {
    private int indent = 0;
    boolean indentEnabled = true;
    boolean newlineEnabled = true;
    private FastStringBuffer buffer;
    private SectionInfo currentSectionInfo;
    NamespaceContextImpl namespaceContext = new NamespaceContextImpl();
    private Map locallyDeclaredPrefix = new SequencedHashMap();
    private Map preferredNamespacePrefixes = new HashMap();
    int nsIndex = 0;
    CharacterEscapeHandler characterEscapeHandler = DumbEscapeHandler.getInstance();
    String lineSep = DEFAULT_LINE_SEPARATOR;
    private static final int MAX_BUFFER_CAPACITY = 10000;
    private static final int DEFAULT_BUFFER_CAPACITY = 5000;
    private static final char[] indents = new char[1000];

    public XMLWriterImpl() {
        this.buffer = new FastStringBuffer(5000);
    }

    @Override
    public void init() {
        this.indent = 0;
        this.buffer.setLength(0);
        this.currentSectionInfo = null;
        this.namespaceContext.clear();
        this.locallyDeclaredPrefix.clear();
        this.preferredNamespacePrefixes.clear();
        this.nsIndex = 0;
        this.lineSep = DEFAULT_LINE_SEPARATOR;
        this.newlineEnabled = true;
        this.indentEnabled = true;
    }

    public String getLineSeparator() {
        return this.lineSep;
    }

    @Override
    public void setLineSeparator(String lineSep) {
        this.lineSep = lineSep;
        if (StringUtils.isEmpty(lineSep)) {
            this.setNewlineEnabled(false);
        }
    }

    public boolean isNewlineEnabled() {
        return this.newlineEnabled;
    }

    public void setNewlineEnabled(boolean newlineEnabled) {
        this.newlineEnabled = newlineEnabled;
        if (!newlineEnabled) {
            this.indentEnabled = false;
        }
    }

    @Override
    public void setCharacterEscapeHandler(CharacterEscapeHandler characterEscapeHandler) {
        this.characterEscapeHandler = characterEscapeHandler;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.startPrefixMapping0(prefix, uri);
        this.addPreferredPrefix(prefix, uri);
    }

    private boolean startPrefixMapping0(String prefix, String uri) {
        if (!this.locallyDeclaredPrefix.containsKey(prefix)) {
            this.namespaceContext.startPrefixMapping(prefix, uri);
            this.locallyDeclaredPrefix.put(prefix, uri);
            return true;
        }
        return false;
    }

    @Override
    public void addPreferredPrefix(String prefix, String namespaceURI) {
        this.preferredNamespacePrefixes.put(namespaceURI, prefix);
    }

    @Override
    public String getOrCreatePrefix(String namespaceURI, boolean forcePrefix) {
        return this.getOrCreatePrefix(namespaceURI, forcePrefix, null);
    }

    String getOrCreatePrefix(String namespaceURI, String usePrefix, SectionInfo sectionInfo) {
        String prefix = this.namespaceContext.getPrefix(namespaceURI);
        if (prefix != null && prefix.equals(usePrefix)) {
            return prefix;
        }
        if (QName.isNullNamespace(namespaceURI)) {
            if (this.namespaceContext.getNamespaceURI("") != null) {
                prefix = "";
                this.createNewPrefix(namespaceURI, prefix, sectionInfo);
            }
        } else {
            this.createNewPrefix(namespaceURI, usePrefix, sectionInfo);
            prefix = usePrefix;
        }
        return prefix;
    }

    String getOrCreatePrefix(String namespaceURI, String newPrefix, boolean forcePrefix, SectionInfo sectionInfo) {
        if (newPrefix != null) {
            return this.getOrCreatePrefix(namespaceURI, newPrefix, sectionInfo);
        }
        return this.getOrCreatePrefix(namespaceURI, forcePrefix, sectionInfo);
    }

    String getOrCreatePrefix(String namespaceURI, boolean forcePrefix, SectionInfo sectionInfo) {
        String prefix = this.namespaceContext.getPrefix(namespaceURI);
        if (prefix == null) {
            if (QName.isNullNamespace(namespaceURI)) {
                if (this.namespaceContext.getNamespaceURI("") != null) {
                    prefix = "";
                    this.createNewPrefix(namespaceURI, prefix, sectionInfo);
                }
            } else {
                prefix = this.createNewPrefix(namespaceURI, sectionInfo, forcePrefix);
            }
        } else if (forcePrefix && prefix.length() == 0) {
            prefix = this.createNewPrefix(namespaceURI, sectionInfo, forcePrefix);
        }
        return prefix;
    }

    private String createNewPrefix(String namespaceURI, SectionInfo sectionInfo, boolean forceNonEmpty) {
        String prefix = this.getOrGeneratePreferredPrefix(namespaceURI, forceNonEmpty);
        this.createNewPrefix(namespaceURI, prefix, sectionInfo);
        return prefix;
    }

    private void createNewPrefix(String namespaceURI, String prefix, SectionInfo sectionInfo) {
        if (sectionInfo != null) {
            if (this.startPrefixMapping0(prefix, namespaceURI)) {
                ++sectionInfo.prefixesCount;
            }
        } else {
            this.locallyDeclaredPrefix.put(prefix, namespaceURI);
        }
    }

    private String getOrGeneratePreferredPrefix(String namespaceURI, boolean forceNonEmpty) {
        String prefix = (String)this.preferredNamespacePrefixes.get(namespaceURI);
        if (prefix == null || forceNonEmpty && prefix.length() == 0) {
            prefix = "ns" + ++this.nsIndex;
            while (this.isPrefixInUse(prefix)) {
                prefix = "ns" + ++this.nsIndex;
            }
            this.addPreferredPrefix(prefix, namespaceURI);
        }
        return prefix;
    }

    private boolean isPrefixInUse(String prefix) {
        return this.preferredNamespacePrefixes.values().contains(prefix);
    }

    @Override
    public void setIndent(int indent) {
        this.indent = indent;
    }

    @Override
    public final Object getOutput() {
        String toRet = this.buffer.toString();
        if (this.buffer.length() > 10000) {
            this.buffer = new FastStringBuffer(5000);
        } else {
            this.buffer.setLength(0);
        }
        return toRet;
    }

    @Override
    public void writeXMLDeclaration(String xmlDecl) {
        this.indent = 0;
        this.buffer.append(xmlDecl);
        if (this.newlineEnabled) {
            this.buffer.append(this.lineSep);
        }
    }

    @Override
    public void writeXMLDeclaration(String version, String encoding) {
        this.writeXMLDeclaration("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"?>");
    }

    @Override
    public void writeTopLevelHeader(String docType) {
        this.buffer.append(docType);
        if (this.newlineEnabled) {
            this.buffer.append(this.lineSep);
        }
        this.currentSectionInfo = null;
    }

    @Override
    public void startElement(QName qName) {
        this.startElement(qName, false);
    }

    @Override
    public void startElement(QName qName, boolean mixedContent) {
        this.startElement(qName, null, mixedContent);
    }

    @Override
    public void startElement(QName qName, String newprefix, boolean mixedContent) {
        boolean hasPrefix;
        this.onWriteSection();
        this.indentElement();
        this.currentSectionInfo = SectionInfo.createNext(qName, mixedContent, this.currentSectionInfo);
        this.buffer.append('<');
        String prefix = this.getOrCreatePrefix(qName.getNamespaceURI(), newprefix, false, this.currentSectionInfo);
        boolean bl = hasPrefix = prefix != null;
        if (hasPrefix && !QName.isDefaultPrefix(prefix)) {
            this.buffer.append(prefix).append(":");
        }
        this.buffer.append(qName.getLocalPart());
        this.writeLocalPrefixes();
        if (qName.hasNamespace() && !hasPrefix) {
            this.buffer.append(" xmlns=\"").append(qName.getNamespaceURI()).append('\"');
        }
        this.currentSectionInfo.prefix = prefix;
    }

    private void indentElement() {
        if (this.currentSectionInfo == null || !this.currentSectionInfo.mixedContent) {
            this.appendIndent(this.buffer);
        }
    }

    @Override
    public void endElement() {
        if (this.currentSectionInfo == null) {
            // empty if block
        }
        if (!this.currentSectionInfo.startClosed) {
            this.buffer.append("/>");
        } else {
            if (this.currentSectionInfo.hasSubElements && !this.currentSectionInfo.isMixedContent()) {
                --this.indent;
                this.appendIndent(this.buffer);
            }
            this.buffer.append("</");
            QName qName = this.currentSectionInfo.qName;
            String prefix = this.currentSectionInfo.prefix;
            if (prefix != null && !QName.isDefaultPrefix(prefix)) {
                this.buffer.append(prefix).append(":");
            }
            this.buffer.append(qName.getLocalPart()).append('>');
        }
        this.namespaceContext.endPrefixMapping(this.currentSectionInfo.prefixesCount);
        this.currentSectionInfo = this.currentSectionInfo.previousInfo;
        this.appendEndOfElementLineFeed();
    }

    private void appendEndOfElementLineFeed() {
        if ((this.currentSectionInfo == null || !this.currentSectionInfo.isMixedContent()) && this.newlineEnabled) {
            this.buffer.append(this.lineSep);
        }
    }

    final void onWriteSection() {
        if (this.currentSectionInfo != null) {
            this.onWriteElement();
        }
    }

    final void onWriteElement() {
        this.closeCurrentElementStart();
        if (this.currentSectionInfo != null) {
            this.currentSectionInfo.hasSubElements = true;
        }
    }

    final void closeCurrentElementStart() {
        if (this.currentSectionInfo != null && !this.currentSectionInfo.startClosed) {
            this.buffer.append('>');
            if (!this.currentSectionInfo.isMixedContent()) {
                if (this.newlineEnabled) {
                    this.buffer.append(this.lineSep);
                }
                ++this.indent;
            }
            this.currentSectionInfo.startClosed = true;
        }
    }

    final void onWriteSubField() {
        this.onWriteElement();
    }

    final void onWriteValue() {
        if (!this.currentSectionInfo.startClosed) {
            this.buffer.append('>');
            this.currentSectionInfo.startClosed = true;
            return;
        }
    }

    private void writeNamespacePrefixAttribute(String prefix, String uri) {
        if (uri == null) {
            uri = "";
        }
        this.buffer.append(' ');
        if ("".equals(prefix)) {
            this.buffer.append("xmlns");
        } else {
            this.buffer.append("xmlns:").append(prefix);
        }
        this.buffer.append("=\"");
        this.writeXMLAttrData(uri, this.buffer);
        this.buffer.append('\"');
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.writeAttribute(new QName(null, localName), value);
    }

    @Override
    public void writeAttribute(QName qName, String value) {
        this.writeAttribute(qName, null, value);
    }

    @Override
    public void writeAttribute(QName qName, String newPrefix, String value) {
        if (value != null) {
            String localPart = qName.getLocalPart();
            String prefix = null;
            if (!QName.isNullNamespace(qName.getNamespaceURI())) {
                prefix = this.getOrCreatePrefix(qName.getNamespaceURI(), newPrefix, true, this.currentSectionInfo);
                this.writeLocalPrefixes();
            }
            this.buffer.append(' ');
            if (prefix != null && !QName.isDefaultPrefix(prefix)) {
                this.buffer.append(prefix);
                if (localPart.length() > 0) {
                    this.buffer.append(':');
                }
            }
            this.buffer.append(localPart).append('=');
            this.buffer.append('\"');
            this.writeXMLAttrData(value, this.buffer);
            this.buffer.append('\"');
        }
    }

    @Override
    public void writeComment(String value) {
        this.closeCurrentElementStart();
        this.indentElement();
        this.buffer.append("<!--").append(value).append("-->");
        this.appendEndOfElementLineFeed();
    }

    @Override
    public void writeElement(QName qName, String value) {
        this.writeElement(qName, null, value);
    }

    public void writeElement(QName qName, String newPrefix, String value) {
        boolean hasPrefix;
        if (value == null) {
            return;
        }
        this.onWriteSubField();
        this.indentElement();
        this.buffer.append('<');
        String prefix = this.getOrCreatePrefix(qName.getNamespaceURI(), newPrefix, false, null);
        boolean bl = hasPrefix = prefix != null;
        if (hasPrefix && !QName.isDefaultPrefix(prefix)) {
            this.buffer.append(prefix).append(":");
        }
        this.buffer.append(qName.getLocalPart());
        this.writeLocalPrefixes();
        if (qName.hasNamespace() && !hasPrefix) {
            this.writeNamespacePrefixAttribute("", qName.getNamespaceURI());
        }
        this.buffer.append('>');
        this.writeXMLCharData(value, this.buffer);
        this.buffer.append("</");
        if (hasPrefix && !QName.isDefaultPrefix(prefix)) {
            this.buffer.append(prefix).append(":");
        }
        this.buffer.append(qName.getLocalPart());
        this.buffer.append('>');
        this.appendEndOfElementLineFeed();
    }

    @Override
    public void writeValue(String value) {
        if (value.length() > 0) {
            this.onWriteValue();
            this.writeXMLCharData(value, this.buffer);
        }
    }

    @Override
    public void insertText(String value) {
        this.buffer.append(value);
    }

    @Override
    public void writeLocalPrefixes() {
        if (!this.locallyDeclaredPrefix.isEmpty()) {
            Iterator iterator = this.locallyDeclaredPrefix.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = iterator.next();
                String p = (String)e.getKey();
                String u = (String)e.getValue();
                if (u == null) {
                    u = "";
                }
                this.writeNamespacePrefixAttribute(p, u);
            }
            this.locallyDeclaredPrefix.clear();
        }
    }

    void appendIndent(FastStringBuffer buffer) {
        if (this.indent < 0 || this.indent > indents.length) {
            new Exception("Indent = " + this.indent).printStackTrace();
        }
        if (this.indentEnabled) {
            buffer.append(indents, 0, Math.max(Math.min(this.indent, indents.length), 0));
        }
    }

    public void writeXMLCharData(String str, FastStringBuffer writeTo) {
        this.characterEscapeHandler.escape(str, writeTo, false);
    }

    public void writeXMLAttrData(String str, FastStringBuffer writeTo) {
        this.characterEscapeHandler.escape(str, writeTo, true);
    }

    public static void cmtmain(String[] args) {
        XMLWriterImpl writer = new XMLWriterImpl();
        writer.init();
        writer.writeXMLDeclaration("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.startElement(new QName("http://www.fixprotocol.org/FIXML-4-4", "FIXML"));
        writer.writeAttribute("xmlns", "http://www.fixprotocol.org/FIXML-4-4");
        writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.endElement();
        System.out.println(writer.getOutput());
    }

    static {
        for (int i = 0; i < indents.length; ++i) {
            XMLWriterImpl.indents[i] = 9;
        }
    }

    static class SectionInfo {
        private QName qName;
        boolean startClosed = false;
        boolean hasSubElements = false;
        SectionInfo previousInfo;
        SectionInfo nextInfo;
        private boolean mixedContent;
        String prefix;
        int prefixesCount;

        public SectionInfo(QName qname, boolean mixedContent, SectionInfo previousInfo) {
            this.qName = qname;
            this.mixedContent = mixedContent;
            this.previousInfo = previousInfo;
        }

        private void init(QName qName, boolean mixedContent) {
            this.qName = qName;
            this.mixedContent = mixedContent;
            this.hasSubElements = false;
            this.startClosed = false;
            this.prefix = null;
            this.prefixesCount = 0;
        }

        SectionInfo createNext(QName qName, boolean mixedContent) {
            if (this.nextInfo == null) {
                this.nextInfo = new SectionInfo(qName, mixedContent, this);
            } else {
                this.nextInfo.init(qName, mixedContent);
            }
            return this.nextInfo;
        }

        static SectionInfo createNext(QName qName, boolean mixedContent, SectionInfo currentSectionInfo) {
            if (currentSectionInfo == null) {
                return new SectionInfo(qName, mixedContent, currentSectionInfo);
            }
            return currentSectionInfo.createNext(qName, mixedContent);
        }

        public boolean isMixedContent() {
            return this.mixedContent;
        }
    }
}

