/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.xml;

import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.XMLUtils;

public class XMLWriterUtil {
    private int indent = 0;
    private static String lineseparator = IOUtil.LINE_SEPARATOR;
    boolean xsiAdded = false;
    boolean indentOutput = true;
    private boolean includeXSI = true;
    private static final String tempIndent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    protected static final String fullindent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public String getXMLDecl() {
        return this.getXMLDecl("UTF-8");
    }

    public boolean isIncludeXSI() {
        return this.includeXSI;
    }

    public void setIncludeXSI(boolean includeXSI) {
        this.includeXSI = includeXSI;
    }

    public boolean isIndentOutput() {
        return this.indentOutput;
    }

    public void setIndentOutput(boolean indentOutput) {
        this.indentOutput = indentOutput;
    }

    public String getXMLDecl(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>" + lineseparator;
    }

    public String tagValue(String tagName, String value) {
        if (value != null) {
            return this.indentStr(this.indent) + "<" + tagName + ">" + XMLWriterUtil.toValueString(value) + "</" + tagName + ">" + lineseparator;
        }
        return "";
    }

    public String tagValueIgnoreEmpty(String tagName, String value) {
        if (value != null && value.length() > 0) {
            return this.indentStr(this.indent) + "<" + tagName + ">" + XMLWriterUtil.toValueString(value) + "</" + tagName + ">" + lineseparator;
        }
        return "";
    }

    public String tagValue(String tagName, boolean value) {
        return this.tagValue(tagName, (value ? Boolean.TRUE : Boolean.FALSE).toString());
    }

    public String tagValue(String tagName, int value) {
        return this.tagValue(tagName, Integer.toString(value));
    }

    public String tagCDATAValue(String tagName, String value) {
        if (value != null) {
            return this.indentStr(this.indent) + "<" + tagName + ">" + XMLWriterUtil.CDATAValue(value) + "</" + tagName + ">" + lineseparator;
        }
        return "";
    }

    public String tagCDATAValueIgnoreEmpty(String tagName, String value) {
        if (value != null && value.length() > 0) {
            return this.indentStr(this.indent) + "<" + tagName + ">" + XMLWriterUtil.CDATAValue(value) + "</" + tagName + ">" + lineseparator;
        }
        return "";
    }

    public String tagValueWithAttrib(String tagName, String value, String attrName, String attrVal) {
        return this.indentStr(this.indent) + "<" + tagName + " " + attrName + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\">" + XMLWriterUtil.toValueString(value) + "</" + tagName + ">" + lineseparator;
    }

    public String tagValueWithAttrib(String tagName, String value, String attrName, String attrVal, String attr2Name, String attr2Val) {
        return this.indentStr(this.indent) + "<" + tagName + " " + attrName + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\"" + " " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\">" + XMLWriterUtil.toValueString(value) + "</" + tagName + ">" + lineseparator;
    }

    public String tagValueWithAttrib(String tagName, String value, String[] attrNameVal) {
        StringBuffer toRet = new StringBuffer();
        this.appendStartTag(tagName, attrNameVal, toRet);
        toRet.append(">").append(XMLWriterUtil.toValueString(value)).append("</").append(tagName).append(">").append(lineseparator);
        return toRet.toString();
    }

    public String tagValueWithAttribCData(String tagName, String value, String[] attrNameVal) {
        StringBuffer toRet = new StringBuffer();
        this.appendStartTag(tagName, attrNameVal, toRet);
        toRet.append(">").append(XMLWriterUtil.CDATAValueNoHacks(value)).append("</").append(tagName).append(">").append(lineseparator);
        return toRet.toString();
    }

    private void appendStartTag(String tagName, String[] attrNameVal, StringBuffer toRet) {
        toRet.append(this.indentStr(this.indent)).append("<").append(tagName);
        for (int i = 0; i < attrNameVal.length; i += 2) {
            String attrVal = attrNameVal[i + 1];
            if (!StringUtils.isNotEmpty(attrVal)) continue;
            toRet.append(" ").append(attrNameVal[i]).append("=\"").append(XMLWriterUtil.fixAttribDoubleQuoted(attrVal)).append("\"");
        }
    }

    public String tagWithAttr(String tagName, String attrName, String attrVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attrName + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\"/>" + lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\"/>" + lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr3Val) + "\"/>" + lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val, String attr4Name, String attr4Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr3Val) + "\" " + attr4Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr4Val) + "\"/>" + lineseparator;
        return toRet;
    }

    public String tagWithAttr(String tagName, String[] attrNameVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " ";
        for (int i = 0; i < attrNameVal.length; i += 2) {
            toRet = toRet + attrNameVal[i] + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrNameVal[i + 1]) + "\" ";
        }
        toRet = toRet + "/>" + lineseparator;
        return toRet;
    }

    public String tagWithAttrIgnoreEmpty(String tagName, String[] attrNameVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + " ";
        for (int i = 0; i < attrNameVal.length; i += 2) {
            String attrVal = attrNameVal[i + 1];
            if (StringUtils.isEmpty(attrVal)) continue;
            toRet = toRet + attrNameVal[i] + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\" ";
        }
        toRet = toRet + "/>" + lineseparator;
        return toRet;
    }

    String injectXSIType() {
        if (this.includeXSI && !this.xsiAdded && this.indent == 0) {
            this.xsiAdded = true;
            return " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        return "";
    }

    public String startTagWithAttr(String tagName, String attrName, String attrVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + " " + attrName + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\">" + lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttrNoLF(String tagName, String attrName, String attrVal) {
        String toRet = "<" + tagName + this.injectXSIType() + " " + attrName + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\">";
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\">" + lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr3Val) + "\">" + lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val, String attr4Name, String attr4Val) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + " " + attr1Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr1Val) + "\" " + attr2Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr2Val) + "\" " + attr3Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr3Val) + "\" " + attr4Name + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attr4Val) + "\">" + lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String[] attrNameVal) {
        return this.startTagWithAttr(tagName, attrNameVal, true);
    }

    public String startTagWithAttrNoLF(String tagName, String[] attrNameVal) {
        return this.startTagWithAttr(tagName, attrNameVal, false);
    }

    public String startTagWithAttr(String tagName, String[] attrNameVal, boolean lf) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + " ";
        for (int i = 0; i < attrNameVal.length; i += 2) {
            String value = attrNameVal[i + 1];
            toRet = toRet + attrNameVal[i] + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(value) + "\" ";
        }
        toRet = toRet + ">";
        if (lf) {
            toRet = toRet + lineseparator;
        }
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttrIgnoreEmpty(String tagName, String[] attrNameVal) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + " ";
        for (int i = 0; i < attrNameVal.length; i += 2) {
            String attrVal = attrNameVal[i + 1];
            if (StringUtils.isEmpty(attrVal)) continue;
            toRet = toRet + attrNameVal[i] + "=\"" + XMLWriterUtil.fixAttribDoubleQuoted(attrVal) + "\" ";
        }
        toRet = toRet + ">" + lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, boolean attr2Val) {
        return this.startTagWithAttr(tagName, attr1Name, XMLWriterUtil.fixAttribDoubleQuoted(attr1Val), attr2Name, attr2Val ? "true" : "false");
    }

    public static String fixNullValue(String tagValue) {
        if (tagValue == null) {
            return "";
        }
        return tagValue;
    }

    public static String fixAttrib(String str) {
        if (str == null) {
            return "";
        }
        return XMLWriterUtil.fixXMLAttribute(str);
    }

    public static String fixAttribDoubleQuoted(String str) {
        if (str == null) {
            return "";
        }
        return XMLWriterUtil.fixXMLAttributeDoubleQuoted(str);
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int newIndent) {
        this.indent = newIndent;
    }

    public String startTag(String tagName) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + this.injectXSIType() + ">" + lineseparator;
        ++this.indent;
        return toRet;
    }

    public String startTagNoLF(String tagName) {
        String toRet = "<" + tagName + ">";
        return toRet;
    }

    public String endTagNoLF(String tagName) {
        String toRet = "</" + tagName + ">";
        return toRet;
    }

    public String startTagCont(String tagName) {
        String toRet = this.indentStr(this.indent) + "<" + tagName + ">";
        return toRet;
    }

    public String endTagCont(String tagName) {
        String toRet = "</" + tagName + ">" + lineseparator;
        return toRet;
    }

    public String endTag(String tagName) {
        --this.indent;
        String toRet = this.indentStr(this.indent) + "</" + tagName + ">" + lineseparator;
        return toRet;
    }

    public static String toValueString(String value) {
        if (value == null) {
            return "";
        }
        return XMLWriterUtil.fixXMLCharData(value);
    }

    public static String CDATAValue(String toWrite) {
        return XMLUtils.CDATAValueSpecial(toWrite);
    }

    public static String CDATAValueNoHacks(String toWrite) {
        return XMLUtils.CDATAValue(toWrite);
    }

    public static String fixXMLAttribute(String str) {
        return XMLUtils.fixXMLAttribute(str);
    }

    public static String fixXMLAttributeDoubleQuoted(String str) {
        return XMLUtils.fixXMLAttributeDoubleQuoted(str);
    }

    public static String fixXMLCharData(String str) {
        return XMLUtils.fixXMLCharData(str);
    }

    public String indentStr(int val) {
        if (this.indentOutput) {
            return fullindent.substring(0, val);
        }
        return "";
    }

    public void setLineSeparator(String lineseparator) {
        XMLWriterUtil.lineseparator = lineseparator;
    }

    public void incrementIndent() {
        ++this.indent;
    }

    public void decrementIndent() {
        --this.indent;
    }

    public String comment(String cmt) {
        return this.indentStr(this.getIndent()) + "<!-- " + cmt + " -->" + lineseparator;
    }
}

