/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.zip;

import com.tplus.transform.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Unzipper {
    JarFile zip;
    String zipFileName;
    String extractDir = ".";

    public Unzipper(String fileName) throws IOException {
        this.zip = new JarFile(fileName);
        this.zipFileName = fileName;
    }

    public void setExtractDirectory(String dir) {
        this.extractDir = dir;
    }

    public boolean extractAll() throws IOException {
        Enumeration<JarEntry> en = this.zip.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            this.extractFile(entry.getName());
        }
        return true;
    }

    public boolean extractFile(String relFileName) throws IOException {
        ZipEntry zipEntry = this.zip.getEntry(relFileName = relFileName.replace('\\', '/'));
        if (zipEntry != null) {
            System.err.println(zipEntry);
            InputStream is = this.zip.getInputStream(zipEntry);
            File file = new File(this.extractDir, zipEntry.getName().replace('/', File.separatorChar));
            if (this.makeDir(file.getParentFile())) {
                FileOutputStream os = new FileOutputStream(file);
                this.copyStreams(is, os);
                is.close();
                os.close();
                return true;
            }
        }
        return false;
    }

    void copyStreams(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        int count = is.read(buffer, 0, 1024);
        while (count > 0) {
            os.write(buffer, 0, count);
            count = is.read(buffer, 0, 1024);
        }
    }

    public void close() {
        try {
            this.zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean makeDir(File dir) {
        if (dir.exists()) {
            return true;
        }
        return FileUtil.mkdirs(dir);
    }
}

