/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.zip;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class Zipper {
    JarOutputStream zs;

    public Zipper(String fileName) throws IOException {
        FileOutputStream fs = new FileOutputStream(fileName);
        this.zs = new JarOutputStream(fs);
    }

    public boolean addFile(String baseDir, String relFileName) throws IOException {
        File file = new File(baseDir, relFileName);
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            relFileName = relFileName.replace('\\', '/');
            JarEntry entry = new JarEntry(relFileName);
            entry.setTime(file.lastModified());
            this.zs.putNextEntry(entry);
            this.copyStream(fis, this.zs);
            this.zs.closeEntry();
            return true;
        }
        return false;
    }

    void copyStream(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = is.read(buffer)) != -1) {
            os.write(buffer, 0, read);
        }
    }

    public boolean addFiles(String baseDir, String relFileName) throws IOException {
        File file = new File(baseDir, relFileName);
        String name = file.getName();
        if (name.startsWith("*.")) {
            final String ext = name.substring(1);
            File parent = file.getParentFile();
            if (parent.exists()) {
                File[] files;
                for (File file1 : files = parent.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathName) {
                        return pathName.getAbsolutePath().endsWith(ext);
                    }
                })) {
                    String clsFile = file1.getAbsolutePath();
                    if ((clsFile = clsFile.substring(baseDir.length())).startsWith("/") || clsFile.startsWith("\\")) {
                        clsFile = clsFile.substring(1);
                    }
                    this.addFile(baseDir, clsFile);
                }
                return true;
            }
        } else {
            this.addFile(baseDir, relFileName);
            return true;
        }
        return false;
    }

    public void close() {
        try {
            this.zs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean addFileAbsolute(String baseDir, String fileName) throws IOException {
        if ((fileName = fileName.substring(baseDir.length())).startsWith("/") || fileName.startsWith("\\")) {
            fileName = fileName.substring(1);
        }
        return this.addFile(baseDir, fileName);
    }
}

