/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.ByteDanceNormalResponseString;
import code.byted.cdp.model.ByteDanceSeqResponseOpenApiManualTagInfo;
import code.byted.cdp.model.ByteDanceSeqResponseSeqDomainGroupedTags;
import code.byted.cdp.model.ByteDanceSeqResponseTagValueResp;
import code.byted.cdp.model.ManualPersonTagRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagApi {
    private ApiClient apiClient;

    public TagApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addOrModifyManualTags
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addOrModifyManualTagsCall(ManualPersonTagRequest body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","addOrModifyManualTags"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addOrModifyManualTagsValidateBeforeCall(ManualPersonTagRequest body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addOrModifyManualTags(Async)");
        }
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling addOrModifyManualTags(Async)");
        }

        com.squareup.okhttp.Call call = addOrModifyManualTagsCall(body, tenantCode, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 添加或者修改某个用户身上的人工标签
     * 
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return ByteDanceNormalResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceNormalResponseString addOrModifyManualTags(ManualPersonTagRequest body, String tenantCode) throws ApiException {
        ApiResponse<ByteDanceNormalResponseString> resp = addOrModifyManualTagsWithHttpInfo(body, tenantCode);
        return resp.getData();
    }

    /**
     * 添加或者修改某个用户身上的人工标签
     * 
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return ApiResponse&lt;ByteDanceNormalResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceNormalResponseString> addOrModifyManualTagsWithHttpInfo(ManualPersonTagRequest body, String tenantCode) throws ApiException {
        com.squareup.okhttp.Call call = addOrModifyManualTagsValidateBeforeCall(body, tenantCode, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 添加或者修改某个用户身上的人工标签 (asynchronously)
     * 
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addOrModifyManualTagsAsync(ManualPersonTagRequest body, String tenantCode, final ApiCallback<ByteDanceNormalResponseString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = addOrModifyManualTagsValidateBeforeCall(body, tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteManualTagsInUser
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteManualTagsInUserCall(String tenantCode, Long baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tagId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tagId", tagId));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("baseId", baseId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteManualTagsInUser"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteManualTagsInUserValidateBeforeCall(String tenantCode, Long baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling deleteManualTagsInUser(Async)");
        }
        // verify the required parameter 'baseId' is set
        if (baseId == null) {
            throw new ApiException("Missing the required parameter 'baseId' when calling deleteManualTagsInUser(Async)");
        }
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling deleteManualTagsInUser(Async)");
        }

        com.squareup.okhttp.Call call = deleteManualTagsInUserCall(tenantCode, baseId, tagId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除某个用户身上的人工标签
     * 
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @return ByteDanceNormalResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceNormalResponseString deleteManualTagsInUser(String tenantCode, Long baseId, Integer tagId) throws ApiException {
        ApiResponse<ByteDanceNormalResponseString> resp = deleteManualTagsInUserWithHttpInfo(tenantCode, baseId, tagId);
        return resp.getData();
    }

    /**
     * 删除某个用户身上的人工标签
     * 
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @return ApiResponse&lt;ByteDanceNormalResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceNormalResponseString> deleteManualTagsInUserWithHttpInfo(String tenantCode, Long baseId, Integer tagId) throws ApiException {
        com.squareup.okhttp.Call call = deleteManualTagsInUserValidateBeforeCall(tenantCode, baseId, tagId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除某个用户身上的人工标签 (asynchronously)
     * 
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteManualTagsInUserAsync(String tenantCode, Long baseId, Integer tagId, final ApiCallback<ByteDanceNormalResponseString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = deleteManualTagsInUserValidateBeforeCall(tenantCode, baseId, tagId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getManualTagsList
     * @param tenantCode 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getManualTagsListCall(String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getManualTagsList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getManualTagsListValidateBeforeCall(String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getManualTagsList(Async)");
        }

        com.squareup.okhttp.Call call = getManualTagsListCall(tenantCode, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询某个用户身上的人工标签列表
     * 
     * @param tenantCode 租户Code (required)
     * @return ByteDanceSeqResponseOpenApiManualTagInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseOpenApiManualTagInfo getManualTagsList(String tenantCode) throws ApiException {
        ApiResponse<ByteDanceSeqResponseOpenApiManualTagInfo> resp = getManualTagsListWithHttpInfo(tenantCode);
        return resp.getData();
    }

    /**
     * 查询某个用户身上的人工标签列表
     * 
     * @param tenantCode 租户Code (required)
     * @return ApiResponse&lt;ByteDanceSeqResponseOpenApiManualTagInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseOpenApiManualTagInfo> getManualTagsListWithHttpInfo(String tenantCode) throws ApiException {
        com.squareup.okhttp.Call call = getManualTagsListValidateBeforeCall(tenantCode, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseOpenApiManualTagInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询某个用户身上的人工标签列表 (asynchronously)
     * 
     * @param tenantCode 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getManualTagsListAsync(String tenantCode, final ApiCallback<ByteDanceSeqResponseOpenApiManualTagInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getManualTagsListValidateBeforeCall(tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseOpenApiManualTagInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getTagValues
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTagValuesCall(String tenantCode, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("tagId", tagId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTagValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTagValuesValidateBeforeCall(String tenantCode, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getTagValues(Async)");
        }
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling getTagValues(Async)");
        }

        com.squareup.okhttp.Call call = getTagValuesCall(tenantCode, tagId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取某个标签的取值
     * 
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @return ByteDanceSeqResponseTagValueResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseTagValueResp getTagValues(String tenantCode, Integer tagId) throws ApiException {
        ApiResponse<ByteDanceSeqResponseTagValueResp> resp = getTagValuesWithHttpInfo(tenantCode, tagId);
        return resp.getData();
    }

    /**
     * 获取某个标签的取值
     * 
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @return ApiResponse&lt;ByteDanceSeqResponseTagValueResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseTagValueResp> getTagValuesWithHttpInfo(String tenantCode, Integer tagId) throws ApiException {
        com.squareup.okhttp.Call call = getTagValuesValidateBeforeCall(tenantCode, tagId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseTagValueResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取某个标签的取值 (asynchronously)
     * 
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTagValuesAsync(String tenantCode, Integer tagId, final ApiCallback<ByteDanceSeqResponseTagValueResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getTagValuesValidateBeforeCall(tenantCode, tagId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseTagValueResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getTagsList
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主题下的base_id类型的ID (optional)
     * @param discardValue 是否移除标签取值势力。默认是false (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTagsListCall(String tenantCode, Integer idType, Boolean discardValue, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (idType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("idType", idType));
        if (discardValue != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("discardValue", discardValue));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTagsList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTagsListValidateBeforeCall(String tenantCode, Integer idType, Boolean discardValue, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getTagsList(Async)");
        }

        com.squareup.okhttp.Call call = getTagsListCall(tenantCode, idType, discardValue, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取所有标签列表，包含各个标签的取值
     * 
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主题下的base_id类型的ID (optional)
     * @param discardValue 是否移除标签取值势力。默认是false (optional)
     * @return ByteDanceSeqResponseSeqDomainGroupedTags
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseSeqDomainGroupedTags getTagsList(String tenantCode, Integer idType, Boolean discardValue) throws ApiException {
        ApiResponse<ByteDanceSeqResponseSeqDomainGroupedTags> resp = getTagsListWithHttpInfo(tenantCode, idType, discardValue);
        return resp.getData();
    }

    /**
     * 获取所有标签列表，包含各个标签的取值
     * 
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主题下的base_id类型的ID (optional)
     * @param discardValue 是否移除标签取值势力。默认是false (optional)
     * @return ApiResponse&lt;ByteDanceSeqResponseSeqDomainGroupedTags&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseSeqDomainGroupedTags> getTagsListWithHttpInfo(String tenantCode, Integer idType, Boolean discardValue) throws ApiException {
        com.squareup.okhttp.Call call = getTagsListValidateBeforeCall(tenantCode, idType, discardValue, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseSeqDomainGroupedTags>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取所有标签列表，包含各个标签的取值 (asynchronously)
     * 
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主题下的base_id类型的ID (optional)
     * @param discardValue 是否移除标签取值势力。默认是false (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTagsListAsync(String tenantCode, Integer idType, Boolean discardValue, final ApiCallback<ByteDanceSeqResponseSeqDomainGroupedTags> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getTagsListValidateBeforeCall(tenantCode, idType, discardValue, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseSeqDomainGroupedTags>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
