/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.LegacySegOpenApiResponse;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.LocalDate;
/**
 * LegacySegOpenApiResponse
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2023-11-17T15:32:30.245+08:00[Asia/Shanghai]")
public class LegacySegOpenApiResponse {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("idType")
  private String idType = null;

  @SerializedName("idTypeName")
  private String idTypeName = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("count")
  private Long count = null;

  @SerializedName("createdBy")
  private String createdBy = null;

  @SerializedName("path")
  private String path = null;

  @SerializedName("exportAt")
  private String exportAt = null;

  /**
   * 分群更新方式
   */
  @JsonAdapter(ExportStrategyEnum.Adapter.class)
  public enum ExportStrategyEnum {
    UNKNOWN("Unknown"),
    ONCE("Once"),
    DAILY("Daily"),
    TRIGGER("Trigger"),
    REALTIME("Realtime");

    private String value;

    ExportStrategyEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ExportStrategyEnum fromValue(String input) {
      for (ExportStrategyEnum b : ExportStrategyEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ExportStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ExportStrategyEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ExportStrategyEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ExportStrategyEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("exportStrategy")
  private ExportStrategyEnum exportStrategy = null;

  /**
   * 分群任务状态
   */
  @JsonAdapter(SegStatusEnum.Adapter.class)
  public enum SegStatusEnum {
    UNKNOWN("Unknown"),
    EXPORTING("Exporting"),
    INVALID("Invalid"),
    NORMAL("Normal");

    private String value;

    SegStatusEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SegStatusEnum fromValue(String input) {
      for (SegStatusEnum b : SegStatusEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SegStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SegStatusEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SegStatusEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SegStatusEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("segStatus")
  private SegStatusEnum segStatus = null;

  @SerializedName("sourceResultReady")
  private Boolean sourceResultReady = null;

  @SerializedName("cantPublicType")
  private String cantPublicType = null;

  @SerializedName("hasPublicBefore")
  private Boolean hasPublicBefore = null;

  @SerializedName("createdAt")
  private String createdAt = null;

  @SerializedName("childSegments")
  private List<LegacySegOpenApiResponse> childSegments = null;

  @SerializedName("version")
  private Integer version = null;

  @SerializedName("onlineSegStatus")
  private Boolean onlineSegStatus = null;

  @SerializedName("pdate")
  private LocalDate pdate = null;

  public LegacySegOpenApiResponse id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 分群id
   * @return id
  **/
  @Schema(required = true, description = "分群id")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public LegacySegOpenApiResponse name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 分群名称
   * @return name
  **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public LegacySegOpenApiResponse idType(String idType) {
    this.idType = idType;
    return this;
  }

   /**
   * 分群实体类型code
   * @return idType
  **/
  @Schema(required = true, description = "分群实体类型code")
  public String getIdType() {
    return idType;
  }

  public void setIdType(String idType) {
    this.idType = idType;
  }

  public LegacySegOpenApiResponse idTypeName(String idTypeName) {
    this.idTypeName = idTypeName;
    return this;
  }

   /**
   * 分群实体类型名称
   * @return idTypeName
  **/
  @Schema(required = true, description = "分群实体类型名称")
  public String getIdTypeName() {
    return idTypeName;
  }

  public void setIdTypeName(String idTypeName) {
    this.idTypeName = idTypeName;
  }

  public LegacySegOpenApiResponse subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(required = true, description = "主体id")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public LegacySegOpenApiResponse count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * 分群数量
   * @return count
  **/
  @Schema(description = "分群数量")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public LegacySegOpenApiResponse createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 分群创建人
   * @return createdBy
  **/
  @Schema(required = true, description = "分群创建人")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public LegacySegOpenApiResponse path(String path) {
    this.path = path;
    return this;
  }

   /**
   * 分群离线文件地址
   * @return path
  **/
  @Schema(description = "分群离线文件地址")
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public LegacySegOpenApiResponse exportAt(String exportAt) {
    this.exportAt = exportAt;
    return this;
  }

   /**
   * 分群离线文件导出时间，未就绪时为当前时间戳
   * @return exportAt
  **/
  @Schema(required = true, description = "分群离线文件导出时间，未就绪时为当前时间戳")
  public String getExportAt() {
    return exportAt;
  }

  public void setExportAt(String exportAt) {
    this.exportAt = exportAt;
  }

  public LegacySegOpenApiResponse exportStrategy(ExportStrategyEnum exportStrategy) {
    this.exportStrategy = exportStrategy;
    return this;
  }

   /**
   * 分群更新方式
   * @return exportStrategy
  **/
  @Schema(required = true, description = "分群更新方式")
  public ExportStrategyEnum getExportStrategy() {
    return exportStrategy;
  }

  public void setExportStrategy(ExportStrategyEnum exportStrategy) {
    this.exportStrategy = exportStrategy;
  }

  public LegacySegOpenApiResponse segStatus(SegStatusEnum segStatus) {
    this.segStatus = segStatus;
    return this;
  }

   /**
   * 分群任务状态
   * @return segStatus
  **/
  @Schema(required = true, description = "分群任务状态")
  public SegStatusEnum getSegStatus() {
    return segStatus;
  }

  public void setSegStatus(SegStatusEnum segStatus) {
    this.segStatus = segStatus;
  }

  public LegacySegOpenApiResponse sourceResultReady(Boolean sourceResultReady) {
    this.sourceResultReady = sourceResultReady;
    return this;
  }

   /**
   * 分群是否就绪
   * @return sourceResultReady
  **/
  @Schema(required = true, description = "分群是否就绪")
  public Boolean isSourceResultReady() {
    return sourceResultReady;
  }

  public void setSourceResultReady(Boolean sourceResultReady) {
    this.sourceResultReady = sourceResultReady;
  }

  public LegacySegOpenApiResponse cantPublicType(String cantPublicType) {
    this.cantPublicType = cantPublicType;
    return this;
  }

   /**
   * 废弃字段
   * @return cantPublicType
  **/
  @Schema(description = "废弃字段")
  public String getCantPublicType() {
    return cantPublicType;
  }

  public void setCantPublicType(String cantPublicType) {
    this.cantPublicType = cantPublicType;
  }

  public LegacySegOpenApiResponse hasPublicBefore(Boolean hasPublicBefore) {
    this.hasPublicBefore = hasPublicBefore;
    return this;
  }

   /**
   * 废弃字段
   * @return hasPublicBefore
  **/
  @Schema(description = "废弃字段")
  public Boolean isHasPublicBefore() {
    return hasPublicBefore;
  }

  public void setHasPublicBefore(Boolean hasPublicBefore) {
    this.hasPublicBefore = hasPublicBefore;
  }

  public LegacySegOpenApiResponse createdAt(String createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * 分群创建时间
   * @return createdAt
  **/
  @Schema(required = true, description = "分群创建时间")
  public String getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }

  public LegacySegOpenApiResponse childSegments(List<LegacySegOpenApiResponse> childSegments) {
    this.childSegments = childSegments;
    return this;
  }

  public LegacySegOpenApiResponse addChildSegmentsItem(LegacySegOpenApiResponse childSegmentsItem) {
    if (this.childSegments == null) {
      this.childSegments = new ArrayList<LegacySegOpenApiResponse>();
    }
    this.childSegments.add(childSegmentsItem);
    return this;
  }

   /**
   * 子包列表
   * @return childSegments
  **/
  @Schema(description = "子包列表")
  public List<LegacySegOpenApiResponse> getChildSegments() {
    return childSegments;
  }

  public void setChildSegments(List<LegacySegOpenApiResponse> childSegments) {
    this.childSegments = childSegments;
  }

  public LegacySegOpenApiResponse version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * 分群在ck中的最新版本号
   * @return version
  **/
  @Schema(description = "分群在ck中的最新版本号")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public LegacySegOpenApiResponse onlineSegStatus(Boolean onlineSegStatus) {
    this.onlineSegStatus = onlineSegStatus;
    return this;
  }

   /**
   * 分群是否开启了在线服务配置
   * @return onlineSegStatus
  **/
  @Schema(description = "分群是否开启了在线服务配置")
  public Boolean isOnlineSegStatus() {
    return onlineSegStatus;
  }

  public void setOnlineSegStatus(Boolean onlineSegStatus) {
    this.onlineSegStatus = onlineSegStatus;
  }

  public LegacySegOpenApiResponse pdate(LocalDate pdate) {
    this.pdate = pdate;
    return this;
  }

   /**
   * Get pdate
   * @return pdate
  **/
  @Schema(description = "")
  public LocalDate getPdate() {
    return pdate;
  }

  public void setPdate(LocalDate pdate) {
    this.pdate = pdate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegacySegOpenApiResponse legacySegOpenApiResponse = (LegacySegOpenApiResponse) o;
    return Objects.equals(this.id, legacySegOpenApiResponse.id) &&
        Objects.equals(this.name, legacySegOpenApiResponse.name) &&
        Objects.equals(this.idType, legacySegOpenApiResponse.idType) &&
        Objects.equals(this.idTypeName, legacySegOpenApiResponse.idTypeName) &&
        Objects.equals(this.subjectId, legacySegOpenApiResponse.subjectId) &&
        Objects.equals(this.count, legacySegOpenApiResponse.count) &&
        Objects.equals(this.createdBy, legacySegOpenApiResponse.createdBy) &&
        Objects.equals(this.path, legacySegOpenApiResponse.path) &&
        Objects.equals(this.exportAt, legacySegOpenApiResponse.exportAt) &&
        Objects.equals(this.exportStrategy, legacySegOpenApiResponse.exportStrategy) &&
        Objects.equals(this.segStatus, legacySegOpenApiResponse.segStatus) &&
        Objects.equals(this.sourceResultReady, legacySegOpenApiResponse.sourceResultReady) &&
        Objects.equals(this.cantPublicType, legacySegOpenApiResponse.cantPublicType) &&
        Objects.equals(this.hasPublicBefore, legacySegOpenApiResponse.hasPublicBefore) &&
        Objects.equals(this.createdAt, legacySegOpenApiResponse.createdAt) &&
        Objects.equals(this.childSegments, legacySegOpenApiResponse.childSegments) &&
        Objects.equals(this.version, legacySegOpenApiResponse.version) &&
        Objects.equals(this.onlineSegStatus, legacySegOpenApiResponse.onlineSegStatus) &&
        Objects.equals(this.pdate, legacySegOpenApiResponse.pdate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, idType, idTypeName, subjectId, count, createdBy, path, exportAt, exportStrategy, segStatus, sourceResultReady, cantPublicType, hasPublicBefore, createdAt, childSegments, version, onlineSegStatus, pdate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegacySegOpenApiResponse {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    idType: ").append(toIndentedString(idType)).append("\n");
    sb.append("    idTypeName: ").append(toIndentedString(idTypeName)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    exportAt: ").append(toIndentedString(exportAt)).append("\n");
    sb.append("    exportStrategy: ").append(toIndentedString(exportStrategy)).append("\n");
    sb.append("    segStatus: ").append(toIndentedString(segStatus)).append("\n");
    sb.append("    sourceResultReady: ").append(toIndentedString(sourceResultReady)).append("\n");
    sb.append("    cantPublicType: ").append(toIndentedString(cantPublicType)).append("\n");
    sb.append("    hasPublicBefore: ").append(toIndentedString(hasPublicBefore)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    childSegments: ").append(toIndentedString(childSegments)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    onlineSegStatus: ").append(toIndentedString(onlineSegStatus)).append("\n");
    sb.append("    pdate: ").append(toIndentedString(pdate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
