/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.ByteDanceResponseRecordSegShardInfoResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationListResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationOnlineServiceEnableReq;
import code.byted.cdp.model.ByteDanceResponseSegmentationOnlineServiceEnableResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationRefreshResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationUploadResp;
import code.byted.cdp.model.CommonResponse;
import java.io.File;
import code.byted.cdp.model.LegacyManualSegCreateRequest;
import code.byted.cdp.model.LegacyUploadedSegCreateRequest;
import code.byted.cdp.model.ManualsegmentUploadBody1;
import code.byted.cdp.model.SegOpenApiFileUploadResponse;
import code.byted.cdp.model.SimplifiedSegCreateOrUpdateRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SegmentationApi {
    private ApiClient apiClient;

    public SegmentationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for createConditionalSegment
     * @param tenantId  (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createConditionalSegmentCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createConditionalSegmentValidateBeforeCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling createConditionalSegment(Async)");
        }

        com.squareup.okhttp.Call call = createConditionalSegmentCall(tenantId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建离线规则-简化
     * 
     * @param tenantId  (required)
     * @param body  (optional)
     * @return ByteDanceResponseSegmentationResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationResp createConditionalSegment(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = createConditionalSegmentWithHttpInfo(tenantId, body);
        return resp.getData();
    }

    /**
     * 创建离线规则-简化
     * 
     * @param tenantId  (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationResp> createConditionalSegmentWithHttpInfo(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = createConditionalSegmentValidateBeforeCall(tenantId, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建离线规则-简化 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createConditionalSegmentAsync(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = createConditionalSegmentValidateBeforeCall(tenantId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for downloadSegFile
     * @param tenantId  (required)
     * @param segId  (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (required)
     * @param needEncrypt  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call downloadSegFileCall(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (formatType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("formatType", formatType));
        if (needEncrypt != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("needEncrypt", needEncrypt));

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","downloadSegFile"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call downloadSegFileValidateBeforeCall(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling downloadSegFile(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling downloadSegFile(Async)");
        }
        // verify the required parameter 'formatType' is set
        if (formatType == null) {
            throw new ApiException("Missing the required parameter 'formatType' when calling downloadSegFile(Async)");
        }

        com.squareup.okhttp.Call call = downloadSegFileCall(tenantId, segId, formatType, needEncrypt, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群ID文件下载
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (required)
     * @param needEncrypt  (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File downloadSegFile(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt) throws ApiException {
        ApiResponse<File> resp = downloadSegFileWithHttpInfo(tenantId, segId, formatType, needEncrypt);
        return resp.getData();
    }

    /**
     * 分群ID文件下载
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (required)
     * @param needEncrypt  (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> downloadSegFileWithHttpInfo(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt) throws ApiException {
        com.squareup.okhttp.Call call = downloadSegFileValidateBeforeCall(tenantId, segId, formatType, needEncrypt, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();

        String[] localVarAccepts = {
            "application/octet-stream", "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群ID文件下载 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (required)
     * @param needEncrypt  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call downloadSegFileAsync(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/octet-stream", "application/json"
        };

        com.squareup.okhttp.Call call = downloadSegFileValidateBeforeCall(tenantId, segId, formatType, needEncrypt, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyCreateManualSegment
     * @param tenantId  (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyCreateManualSegmentCall(Integer tenantId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyCreateManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyCreateManualSegmentValidateBeforeCall(Integer tenantId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateManualSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyCreateManualSegmentCall(tenantId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建人工分群
     * 
     * @param tenantId  (required)
     * @param body  (optional)
     * @return ByteDanceResponseSegmentationResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationResp legacyCreateManualSegment(Integer tenantId, LegacyManualSegCreateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = legacyCreateManualSegmentWithHttpInfo(tenantId, body);
        return resp.getData();
    }

    /**
     * 创建人工分群
     * 
     * @param tenantId  (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationResp> legacyCreateManualSegmentWithHttpInfo(Integer tenantId, LegacyManualSegCreateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = legacyCreateManualSegmentValidateBeforeCall(tenantId, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建人工分群 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyCreateManualSegmentAsync(Integer tenantId, LegacyManualSegCreateRequest body, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = legacyCreateManualSegmentValidateBeforeCall(tenantId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyCreateUploadSegment
     * @param body  (required)
     * @param tenantId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyCreateUploadSegmentCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyCreateUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyCreateUploadSegmentValidateBeforeCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateUploadSegment(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateUploadSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyCreateUploadSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建上传分群
     * 
     * @param body  (required)
     * @param tenantId  (required)
     * @return ByteDanceResponseRecordSegShardInfoResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseRecordSegShardInfoResp legacyCreateUploadSegment(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseRecordSegShardInfoResp> resp = legacyCreateUploadSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    /**
     * 创建上传分群
     * 
     * @param body  (required)
     * @param tenantId  (required)
     * @return ApiResponse&lt;ByteDanceResponseRecordSegShardInfoResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseRecordSegShardInfoResp> legacyCreateUploadSegmentWithHttpInfo(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建上传分群 (asynchronously)
     * 
     * @param body  (required)
     * @param tenantId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyCreateUploadSegmentAsync(LegacyUploadedSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseRecordSegShardInfoResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyDeleteSegment
     * @param tenantId  (required)
     * @param segId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyDeleteSegmentCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyDeleteSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyDeleteSegmentValidateBeforeCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyDeleteSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyDeleteSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyDeleteSegmentCall(tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除分群
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void legacyDeleteSegment(Integer tenantId, Integer segId) throws ApiException {
        legacyDeleteSegmentWithHttpInfo(tenantId, segId);
    }

    /**
     * 删除分群
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> legacyDeleteSegmentWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = legacyDeleteSegmentValidateBeforeCall(tenantId, segId, null, null);
        return apiClient.execute(call);
    }

    /**
     * 删除分群 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyDeleteSegmentAsync(Integer tenantId, Integer segId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            
        };

        com.squareup.okhttp.Call call = legacyDeleteSegmentValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for legacyGetSegment
     * @param tenantId  (required)
     * @param segId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyGetSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyGetSegmentValidateBeforeCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyGetSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyGetSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyGetSegmentCall(tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群详情
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ByteDanceResponseSegmentationResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationResp legacyGetSegment(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = legacyGetSegmentWithHttpInfo(tenantId, segId);
        return resp.getData();
    }

    /**
     * 分群详情
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationResp> legacyGetSegmentWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = legacyGetSegmentValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群详情 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyGetSegmentValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyGetSegmentList
     * @param tenantId  (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentListCall(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (current != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("current", current));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
        if (isSelfSee != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isSelfSee", isSelfSee));
        if (isOnlySourceReady != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isOnlySourceReady", isOnlySourceReady));
        if (idType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("idType", idType));
        if (segTypes != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("segTypes", segTypes));
        if (sourcePlatform != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sourcePlatform", sourcePlatform));
        if (isAbaseAvailable != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isAbaseAvailable", isAbaseAvailable));
        if (isAbaseEnabled != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isAbaseEnabled", isAbaseEnabled));

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyGetSegmentList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyGetSegmentListValidateBeforeCall(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyGetSegmentList(Async)");
        }

        com.squareup.okhttp.Call call = legacyGetSegmentListCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群列表查看，分页
     * 
     * @param tenantId  (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @return ByteDanceResponseSegmentationListResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationListResp legacyGetSegmentList(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationListResp> resp = legacyGetSegmentListWithHttpInfo(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled);
        return resp.getData();
    }

    /**
     * 分群列表查看，分页
     * 
     * @param tenantId  (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationListResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationListResp> legacyGetSegmentListWithHttpInfo(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled) throws ApiException {
        com.squareup.okhttp.Call call = legacyGetSegmentListValidateBeforeCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationListResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群列表查看，分页 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentListAsync(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, final ApiCallback<ByteDanceResponseSegmentationListResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyGetSegmentListValidateBeforeCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationListResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyModifyManualSegment
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyModifyManualSegmentCall(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyModifyManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyModifyManualSegmentValidateBeforeCall(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyModifyManualSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyModifyManualSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyModifyManualSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 修改人工分群
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void legacyModifyManualSegment(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body) throws ApiException {
        legacyModifyManualSegmentWithHttpInfo(tenantId, segId, body);
    }

    /**
     * 修改人工分群
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> legacyModifyManualSegmentWithHttpInfo(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        return apiClient.execute(call);
    }

    /**
     * 修改人工分群 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyModifyManualSegmentAsync(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            
        };

        com.squareup.okhttp.Call call = legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for modifyConditionalSegment
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call modifyConditionalSegmentCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","modifyConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call modifyConditionalSegmentValidateBeforeCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling modifyConditionalSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifyConditionalSegment(Async)");
        }

        com.squareup.okhttp.Call call = modifyConditionalSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 修改离线规则-简化
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @return CommonResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponse modifyConditionalSegment(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<CommonResponse> resp = modifyConditionalSegmentWithHttpInfo(tenantId, segId, body);
        return resp.getData();
    }

    /**
     * 修改离线规则-简化
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponse> modifyConditionalSegmentWithHttpInfo(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 修改离线规则-简化 (asynchronously)
     * 
     * @param tenantId  (required)
     * @param segId  (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call modifyConditionalSegmentAsync(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<CommonResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for refreshSeg
     * @param tenantId  (required)
     * @param segId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call refreshSegCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","refreshSeg"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call refreshSegValidateBeforeCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling refreshSeg(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling refreshSeg(Async)");
        }

        com.squareup.okhttp.Call call = refreshSegCall(tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 更新单个分群
     * 更新单个分群
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ByteDanceResponseSegmentationRefreshResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationRefreshResp refreshSeg(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationRefreshResp> resp = refreshSegWithHttpInfo(tenantId, segId);
        return resp.getData();
    }

    /**
     * 更新单个分群
     * 更新单个分群
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationRefreshResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationRefreshResp> refreshSegWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = refreshSegValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 更新单个分群 (asynchronously)
     * 更新单个分群
     * @param tenantId  (required)
     * @param segId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call refreshSegAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationRefreshResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = refreshSegValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for segmentOnlineServiceEnable
     * @param body  (required)
     * @param tenantId  (required)
     * @param segId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call segmentOnlineServiceEnableCall(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","segmentOnlineServiceEnable"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call segmentOnlineServiceEnableValidateBeforeCall(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling segmentOnlineServiceEnable(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling segmentOnlineServiceEnable(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling segmentOnlineServiceEnable(Async)");
        }

        com.squareup.okhttp.Call call = segmentOnlineServiceEnableCall(body, tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群在线服务开启/关闭
     * 开启/关闭单个分群的在线服务
     * @param body  (required)
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ByteDanceResponseSegmentationOnlineServiceEnableResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationOnlineServiceEnableResp segmentOnlineServiceEnable(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationOnlineServiceEnableResp> resp = segmentOnlineServiceEnableWithHttpInfo(body, tenantId, segId);
        return resp.getData();
    }

    /**
     * 分群在线服务开启/关闭
     * 开启/关闭单个分群的在线服务
     * @param body  (required)
     * @param tenantId  (required)
     * @param segId  (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationOnlineServiceEnableResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationOnlineServiceEnableResp> segmentOnlineServiceEnableWithHttpInfo(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = segmentOnlineServiceEnableValidateBeforeCall(body, tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationOnlineServiceEnableResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群在线服务开启/关闭 (asynchronously)
     * 开启/关闭单个分群的在线服务
     * @param body  (required)
     * @param tenantId  (required)
     * @param segId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call segmentOnlineServiceEnableAsync(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationOnlineServiceEnableResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = segmentOnlineServiceEnableValidateBeforeCall(body, tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationOnlineServiceEnableResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for uploadSegFile
     * @param file  (required)
     * @param tenantId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","uploadSegFile"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadSegFileValidateBeforeCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadSegFile(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFile(Async)");
        }

        com.squareup.okhttp.Call call = uploadSegFileCall(file, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传分群文件
     * 
     * @param file  (required)
     * @param tenantId  (required)
     * @return ByteDanceResponseSegmentationUploadResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationUploadResp uploadSegFile(File file, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationUploadResp> resp = uploadSegFileWithHttpInfo(file, tenantId);
        return resp.getData();
    }

    /**
     * 上传分群文件
     * 
     * @param file  (required)
     * @param tenantId  (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationUploadResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationUploadResp> uploadSegFileWithHttpInfo(File file, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = uploadSegFileValidateBeforeCall(file, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传分群文件 (asynchronously)
     * 
     * @param file  (required)
     * @param tenantId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileAsync(File file, Integer tenantId, final ApiCallback<ByteDanceResponseSegmentationUploadResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = uploadSegFileValidateBeforeCall(file, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for uploadSegFileToCh
     * @param file  (required)
     * @param tenantId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileToChCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","uploadSegFileToCh"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data", "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadSegFileToChValidateBeforeCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadSegFileToCh(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFileToCh(Async)");
        }

        com.squareup.okhttp.Call call = uploadSegFileToChCall(file, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传人工分群文件
     * 
     * @param file  (required)
     * @param tenantId  (required)
     * @return SegOpenApiFileUploadResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SegOpenApiFileUploadResponse uploadSegFileToCh(File file, Integer tenantId) throws ApiException {
        ApiResponse<SegOpenApiFileUploadResponse> resp = uploadSegFileToChWithHttpInfo(file, tenantId);
        return resp.getData();
    }

    /**
     * 上传人工分群文件
     * 
     * @param file  (required)
     * @param tenantId  (required)
     * @return ApiResponse&lt;SegOpenApiFileUploadResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SegOpenApiFileUploadResponse> uploadSegFileToChWithHttpInfo(File file, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = uploadSegFileToChValidateBeforeCall(file, tenantId, null, null);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传人工分群文件 (asynchronously)
     * 
     * @param file  (required)
     * @param tenantId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileToChAsync(File file, Integer tenantId, final ApiCallback<SegOpenApiFileUploadResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = uploadSegFileToChValidateBeforeCall(file, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for uploadSegFileToCh
     * @param body  (required)
     * @param tenantId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileToChCall(ManualsegmentUploadBody1 body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","uploadSegFileToCh"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data", "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadSegFileToChValidateBeforeCall(ManualsegmentUploadBody1 body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling uploadSegFileToCh(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFileToCh(Async)");
        }

        com.squareup.okhttp.Call call = uploadSegFileToChCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传人工分群文件
     * 
     * @param body  (required)
     * @param tenantId  (required)
     * @return SegOpenApiFileUploadResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SegOpenApiFileUploadResponse uploadSegFileToCh(ManualsegmentUploadBody1 body, Integer tenantId) throws ApiException {
        ApiResponse<SegOpenApiFileUploadResponse> resp = uploadSegFileToChWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    /**
     * 上传人工分群文件
     * 
     * @param body  (required)
     * @param tenantId  (required)
     * @return ApiResponse&lt;SegOpenApiFileUploadResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SegOpenApiFileUploadResponse> uploadSegFileToChWithHttpInfo(ManualsegmentUploadBody1 body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = uploadSegFileToChValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传人工分群文件 (asynchronously)
     * 
     * @param body  (required)
     * @param tenantId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileToChAsync(ManualsegmentUploadBody1 body, Integer tenantId, final ApiCallback<SegOpenApiFileUploadResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = uploadSegFileToChValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SegOpenApiFileUploadResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
